/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.themes.user;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.confluence.user.ConfluenceUserResolver;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.user.UserPreferencesAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.theme.api.Theme;
import com.atlassian.theme.api.ThemeColorMode;
import com.atlassian.theme.internal.api.ThemeService;
import com.atlassian.theme.internal.api.user.PreferredColorMode;
import com.atlassian.theme.internal.api.user.UserThemeService;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class DefaultUserThemeService
implements UserThemeService {
    private static final String PREFERRED_COLOR_MODE_KEY = "atl-theme-preferred-color-mode";
    private static final String PREFERRED_DARK_THEME = "atl-theme-preferred-dark-theme";
    private static final String PREFERRED_LIGHT_THEME = "atl-theme-preferred-light-theme";
    private final ConfluenceUserResolver confluenceUserResolver;
    private final ThemeService themeService;
    private final UserPreferencesAccessor userPreferencesAccessor;

    public DefaultUserThemeService(@NonNull ConfluenceUserResolver confluenceUserResolver, @NonNull ThemeService themeService, @NonNull UserPreferencesAccessor userPreferencesAccessor) {
        this.confluenceUserResolver = Objects.requireNonNull(confluenceUserResolver, "confluenceUserResolver");
        this.themeService = Objects.requireNonNull(themeService, "themeService");
        this.userPreferencesAccessor = Objects.requireNonNull(userPreferencesAccessor, "userPreferencesAccessor");
    }

    public Optional<PreferredColorMode> getPreferredColorMode(UserKey userKey) {
        Objects.requireNonNull(userKey, "userKey");
        return Optional.of(this.getUserPreferences(userKey).getString(PREFERRED_COLOR_MODE_KEY).flatMap(PreferredColorMode::optionalValueOf).orElse(PreferredColorMode.MATCHING));
    }

    public Optional<Theme> getPreferredDarkTheme(UserKey userKey) {
        Objects.requireNonNull(userKey, "userKey");
        return this.themeService.findMatchingTheme(ThemeColorMode.DARK, (String)this.getUserPreferences(userKey).getString(PREFERRED_DARK_THEME).orElse(null));
    }

    public Optional<Theme> getPreferredLightTheme(UserKey userKey) {
        Objects.requireNonNull(userKey, "userKey");
        return this.themeService.findMatchingTheme(ThemeColorMode.LIGHT, (String)this.getUserPreferences(userKey).getString(PREFERRED_LIGHT_THEME).orElse(null));
    }

    public void setPreferredColorMode(UserKey userKey, PreferredColorMode preferredColorMode) {
        Objects.requireNonNull(userKey, "userKey");
        Objects.requireNonNull(preferredColorMode, "preferredColorMode");
        this.getUserPreferences(userKey).setString(PREFERRED_COLOR_MODE_KEY, preferredColorMode.toString());
    }

    public void setPreferredDarkTheme(UserKey userKey, Theme theme) {
        Objects.requireNonNull(userKey, "userKey");
        Objects.requireNonNull(theme, "theme");
        this.getUserPreferences(userKey).setString(PREFERRED_DARK_THEME, theme.getThemeKey());
    }

    public void setPreferredLightTheme(UserKey userKey, Theme theme) {
        Objects.requireNonNull(userKey, "userKey");
        Objects.requireNonNull(theme, "theme");
        this.getUserPreferences(userKey).setString(PREFERRED_LIGHT_THEME, theme.getThemeKey());
    }

    private UserPreferences getUserPreferences(@NonNull UserKey userKey) {
        Objects.requireNonNull(userKey, "userKey");
        return this.userPreferencesAccessor.getUserPreferences(this.confluenceUserResolver.getUserByKey(userKey));
    }
}

