/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.atlassian.confluence.core.PersistentDecorator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistentDecoratorUpgradeHelper {
    private static final Logger logger = LoggerFactory.getLogger(PersistentDecoratorUpgradeHelper.class);
    static final String LEGACY_PARSE = "#parse \\(\"/langmacro.vm\"\\)";
    static final String LEGACY_HTML_LANG_TARGET_REG = " #langAttr\\(\\)";
    static final String HTML_TARGET_REG = "<html(.*)>";
    static final Pattern NEW_LANG_STR_REG = Pattern.compile("<html(?:(?!lang=\"\\$action\\.getLanguageJs\\(\\)\").)*>");
    static final String HTML_ADDITION_STR = "<html lang=\"\\$action.getLanguageJs()\"$1>";

    private PersistentDecoratorUpgradeHelper() {
    }

    public static String replaceLangMacroInDecorator(String body, String decoratorName) {
        if (PersistentDecoratorUpgradeHelper.isDecoratorEffected(decoratorName)) {
            body = PersistentDecoratorUpgradeHelper.performReplacement(body, LEGACY_PARSE, "");
            Matcher matcher = NEW_LANG_STR_REG.matcher(body = PersistentDecoratorUpgradeHelper.performReplacement(body, LEGACY_HTML_LANG_TARGET_REG, ""));
            if (matcher.find()) {
                body = PersistentDecoratorUpgradeHelper.performReplacement(body, HTML_TARGET_REG, HTML_ADDITION_STR);
            } else {
                logger.debug("Decorator with name: {} already has the new lang macro replacement", (Object)decoratorName);
            }
        } else {
            logger.debug("Skipping Decorator with name: {}", (Object)decoratorName);
        }
        return body;
    }

    public static void replaceLangMacroInDecorator(PersistentDecorator decorator) {
        String body = decorator.getBody();
        String decoratorName = decorator.getName();
        decorator.setBody(PersistentDecoratorUpgradeHelper.replaceLangMacroInDecorator(body, decoratorName));
    }

    private static String performReplacement(String body, String targetReg, String replacementReg) {
        return body.replaceFirst(targetReg, replacementReg);
    }

    private static boolean isDecoratorEffected(String decoratorName) {
        return decoratorName.equals("decorators/main.vmd") || decoratorName.equals("decorators/login.vmd") || decoratorName.equals("decorators/admin.vmd");
    }
}

