/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.ddl;

import com.atlassian.config.db.HibernateConfig;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.persistence.hibernate.HibernateDatabaseCapabilities;
import com.atlassian.confluence.upgrade.ddl.AlterTableCommand;
import org.apache.commons.lang3.StringUtils;

public class AddStringVirtualColumnForNullableColumnCommand
implements AlterTableCommand {
    private static final String POSTGRESQL_COMMAND_PARAMETERS = "%s %s GENERATED ALWAYS AS (COALESCE(%s, '%s')) STORED";
    private static final String MYSQL_COMMAND_PARAMETERS = "%s %s AS (COALESCE(%s, '%s')) VIRTUAL";
    private static final String ORACLE_COMMAND_PARAMETERS = "(%s %s GENERATED ALWAYS AS (COALESCE(%s, CAST('%s' AS %s))) VIRTUAL)";
    private static final String SQL_SERVER_COMMAND_PARAMETERS = "%s AS (COALESCE(%s, '%s'))";
    private static final String H2_COMMAND_PARAMETERS = "%s %s AS (COALESCE(%s, '%s'))";
    public static final String ORACLE_VARCHAR_TYPE = "NVARCHAR2(255)";
    private static final String GENERAL_VARCHAR_TYPE = "VARCHAR(255)";
    private final String virtualColumnName;
    private final String virtualColumnType;
    private final String sourceColumnName;
    private final String placeHolder;

    public AddStringVirtualColumnForNullableColumnCommand(String virtualColumnName, String sourceColumnName, String virtualColumnType, String placeHolder) {
        this.virtualColumnName = virtualColumnName;
        this.sourceColumnName = sourceColumnName;
        this.virtualColumnType = virtualColumnType;
        this.placeHolder = placeHolder;
    }

    @Override
    public String getCommandName() {
        if (this.getHibernateConfig().isOracle() || this.getHibernateConfig().isSqlServer()) {
            return "add ";
        }
        return "add column ";
    }

    @Override
    public String getCommandParameters() {
        HibernateDatabaseCapabilities hibernateConfig = this.getHibernateConfig();
        String varcharType = this.getColumnType();
        if (hibernateConfig.isPostgreSql()) {
            return String.format(POSTGRESQL_COMMAND_PARAMETERS, this.virtualColumnName, varcharType, this.sourceColumnName, this.placeHolder);
        }
        if (hibernateConfig.isMySql()) {
            return String.format(MYSQL_COMMAND_PARAMETERS, this.virtualColumnName, varcharType, this.sourceColumnName, this.placeHolder);
        }
        if (hibernateConfig.isOracle()) {
            return String.format(ORACLE_COMMAND_PARAMETERS, this.virtualColumnName, varcharType, this.sourceColumnName, this.placeHolder, varcharType);
        }
        if (hibernateConfig.isSqlServer()) {
            return String.format(SQL_SERVER_COMMAND_PARAMETERS, this.virtualColumnName, this.sourceColumnName, this.placeHolder);
        }
        if (hibernateConfig.isH2()) {
            return String.format(H2_COMMAND_PARAMETERS, this.virtualColumnName, varcharType, this.sourceColumnName, this.placeHolder);
        }
        throw new UnsupportedOperationException("Unsupported database type");
    }

    private HibernateDatabaseCapabilities getHibernateConfig() {
        return HibernateDatabaseCapabilities.from((HibernateConfig)BootstrapUtils.getBootstrapManager().getHibernateConfig());
    }

    private String getColumnType() {
        if (!StringUtils.isBlank((CharSequence)this.virtualColumnType)) {
            return this.virtualColumnType;
        }
        return this.getHibernateConfig().isOracle() ? ORACLE_VARCHAR_TYPE : GENERAL_VARCHAR_TYPE;
    }
}

