/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.impl;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.core.persistence.VersionHistoryDao;
import com.atlassian.confluence.event.events.admin.UpgradeFinishedEvent;
import com.atlassian.confluence.event.events.admin.UpgradeStartedEvent;
import com.atlassian.confluence.impl.cache.CacheFlusher;
import com.atlassian.confluence.impl.cluster.ClusterConfigurationHelperInternal;
import com.atlassian.confluence.impl.core.persistence.hibernate.schema.ConfluenceSchemaHelper;
import com.atlassian.confluence.internal.health.JohnsonEventLevel;
import com.atlassian.confluence.internal.health.JohnsonEventType;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.johnson.JohnsonUtils;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.upgrade.AbstractUpgradeManager;
import com.atlassian.confluence.upgrade.DeferredUpgradeTask;
import com.atlassian.confluence.upgrade.UpgradeError;
import com.atlassian.confluence.upgrade.UpgradeException;
import com.atlassian.confluence.upgrade.UpgradeFinalizationManager;
import com.atlassian.confluence.upgrade.UpgradeGate;
import com.atlassian.confluence.upgrade.UpgradeHistoryService;
import com.atlassian.confluence.upgrade.UpgradeTask;
import com.atlassian.confluence.upgrade.recovery.DbDumpException;
import com.atlassian.confluence.upgrade.recovery.RecoveryFileGenerator;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.web.UrlBuilder;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import io.atlassian.util.concurrent.Lazy;
import java.io.File;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.math.NumberUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUpgradeManager
extends AbstractUpgradeManager
implements UpgradeHistoryService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUpgradeManager.class);
    private static final String CLUSTER_UPGRADE_LOCK = "cluster.upgrade.lock";
    private CacheFlusher cacheFlusher;
    private EventPublisher eventPublisher;
    private VersionHistoryDao versionHistoryDao;
    private ClusterManager clusterManager;
    private UpgradeGate upgradeGate;
    private RecoveryFileGenerator recoveryFileGenerator;
    private ClusterConfigurationHelperInternal clusterConfigurationHelper;
    private FilesystemPath confluenceHome;
    private UpgradeFinalizationManager finalizationManager;
    private ClusterLockService clusterLockService;
    private LicenseService licenseService;
    private GlobalSettingsManager globalSettingsManager;
    private Integer initialConfiguredBuildNumber;
    private ConfluenceSchemaHelper schemaHelper;
    private final Supplier<Boolean> permitDatabaseUpgrades = Lazy.supplier(() -> this.tryAcquireDatabaseUpgradesLock(Objects.requireNonNull(this.initialConfiguredBuildNumber, "initialConfiguredBuildNumber has not yet been initialised")));

    public void setFinalizationManager(UpgradeFinalizationManager finalizationManager) {
        this.finalizationManager = finalizationManager;
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setGlobalSettingsManager(GlobalSettingsManager globalSettingsManager) {
        this.globalSettingsManager = globalSettingsManager;
    }

    public void setSchemaHelper(ConfluenceSchemaHelper schemaHelper) {
        this.schemaHelper = schemaHelper;
    }

    protected void validateSchemaUpdateIfNeeded() throws ConfigurationException {
        this.schemaHelper.validateSchemaUpdateIfNeeded();
    }

    protected void updateSchemaIfNeeded() throws ConfigurationException {
        this.schemaHelper.updateSchemaIfNeeded();
    }

    protected void releaseSchemaReferences() {
        this.schemaHelper.reset();
    }

    protected void finalizeIfNeeded() throws UpgradeException {
        if (this.permitDatabaseUpgrades()) {
            this.finalizationManager.finalizeIfNeeded();
        } else {
            try {
                this.finalizationManager.markAsFullyFinalized(false);
            }
            catch (ConfigurationException e) {
                throw new UpgradeException((Throwable)e);
            }
        }
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.initialConfiguredBuildNumber = Integer.parseInt(this.getConfiguredBuildNumber());
    }

    protected String getRealBuildNumber() {
        return GeneralUtil.getBuildNumber();
    }

    protected String getDatabaseBuildNumber() {
        int databaseBuildNumber = this.versionHistoryDao.getLatestBuildNumber();
        return databaseBuildNumber == 0 ? this.getConfiguredBuildNumber() : Integer.toString(databaseBuildNumber);
    }

    protected List<UpgradeError> runUpgradePrerequisites() {
        return this.attachmentStoragePrerequisiteCheck().map(List::of).orElse(Collections.emptyList());
    }

    private Optional<UpgradeError> attachmentStoragePrerequisiteCheck() {
        if ("database.based.attachments.storage".equals(this.globalSettingsManager.getGlobalSettings().getAttachmentDataStore())) {
            String message = "Database attachment storage is not supported. You must migrate your attachments to the file system before upgrading Confluence.";
            String urlString = "https://confluence.atlassian.com/display/DOC/Attachment+Storage+Configuration";
            return Optional.of(new UpgradeError(message, UrlBuilder.createURL(urlString)));
        }
        return Optional.empty();
    }

    public boolean needUpgrade() {
        boolean needed = super.needUpgrade();
        this.upgradeGate.setUpgradeRequired(needed);
        return needed;
    }

    public void setDatabaseBuildNumber() {
        try {
            this.setDatabaseBuildNumber(this.getConfiguredBuildNumber());
        }
        catch (Exception e) {
            log.warn("Unable to set build number '{}' in the database", (Object)this.getConfiguredBuildNumber(), (Object)e);
        }
    }

    protected void setDatabaseBuildNumber(String databaseBuildNumber) throws Exception {
        try {
            int currentBuildNumber = Integer.parseInt(databaseBuildNumber);
            int previousBuildNumber = this.versionHistoryDao.getLatestBuildNumber();
            if (previousBuildNumber < currentBuildNumber && this.permitDatabaseUpgrades()) {
                this.versionHistoryDao.addBuildToHistory(currentBuildNumber);
            } else {
                log.info("Not setting database version on subsequent nodes of cluster. Database upgrades have already been run.");
            }
        }
        catch (NumberFormatException e) {
            log.warn("Unable to write build number to database - build number could not be parsed: {}", (Object)databaseBuildNumber);
        }
    }

    protected void beforeUpgrade() {
        this.eventPublisher.publish((Object)new UpgradeStartedEvent((Object)this));
        if (this.isUpgradeRecoveryFileEnabled()) {
            log.info("Generating pre-upgrade recovery file...");
            try {
                this.recoveryFileGenerator.generate(this.createUpgradeRecoveryFile("before"));
                log.info("Finished generating pre-upgrade recovery file.");
            }
            catch (DbDumpException e) {
                this.failOnDbDumpException("Pre-Upgrade", e);
            }
        }
    }

    private void failOnDbDumpException(String stage, DbDumpException e) {
        String row1 = stage + " recovery file generation failed.";
        String row2 = "Please refer to https://confluence.atlassian.com/x/ropKGQ for possible solution.";
        log.error(Joiner.on((char)'\n').join((Object)row1, (Object)"Please refer to https://confluence.atlassian.com/x/ropKGQ for possible solution.", new Object[0]), (Throwable)((Object)e));
        JohnsonUtils.raiseJohnsonEvent((JohnsonEventType)JohnsonEventType.STARTUP, (String)Joiner.on((String)"<br>").join((Object)row1, (Object)"Please refer to https://confluence.atlassian.com/x/ropKGQ for possible solution.", new Object[0]), (String)e.getMessage(), (JohnsonEventLevel)JohnsonEventLevel.FATAL);
    }

    private File createUpgradeRecoveryFile(String qualifier) {
        File directory = new File(this.getConfluenceHome(), "recovery");
        if (!directory.exists()) {
            directory.mkdir();
        }
        String prefix = "upgradeRecoveryFile-" + this.initialConfiguredBuildNumber + "-" + this.getRealBuildNumber() + "-" + qualifier;
        String postfix = ".xml.gz";
        File candidate = new File(directory, prefix + postfix);
        int counter = 2;
        while (candidate.exists()) {
            candidate = new File(directory, prefix + "-" + counter + postfix);
            ++counter;
        }
        return candidate;
    }

    private File getConfluenceHome() {
        if (this.confluenceHome != null) {
            return this.confluenceHome.asJavaFile();
        }
        BootstrapManager bootstrapManager = (BootstrapManager)BootstrapUtils.getBootstrapManager();
        return new File(bootstrapManager.getConfluenceHome());
    }

    protected void postUpgrade() {
        this.cacheFlusher.flushCaches();
    }

    protected void initialUpgradeFinished() throws Exception {
        super.initialUpgradeFinished();
        if (this.clusterConfigurationHelper.isClusterHomeConfigured()) {
            long realBuildNumber;
            Optional sharedBuildNumberOpt = this.clusterConfigurationHelper.getSharedBuildNumber();
            long sharedBuildNumber = 0L;
            if (sharedBuildNumberOpt.isPresent()) {
                sharedBuildNumber = NumberUtils.toLong((String)((String)sharedBuildNumberOpt.get()), (long)0L);
            }
            if ((realBuildNumber = NumberUtils.toLong((String)this.getRealBuildNumber(), (long)0L)) > sharedBuildNumber) {
                this.clusterConfigurationHelper.saveSharedBuildNumber(this.getRealBuildNumber());
            }
        }
        if (!this.deferredTasksOutstanding()) {
            this.upgradeGate.setPluginDependentUpgradeComplete(true);
        }
    }

    private boolean deferredTasksOutstanding() {
        for (DeferredUpgradeTask task : this.getPluginDependentUpgradeTasks()) {
            if (!task.isUpgradeRequired()) continue;
            return true;
        }
        return false;
    }

    public void entireUpgradeFinished() {
        if (this.isUpgradeRecoveryFileEnabled()) {
            log.info("Generating post-upgrade recovery file...");
            try {
                this.cacheFlusher.flushCaches();
                this.recoveryFileGenerator.generate(this.createUpgradeRecoveryFile("after"));
                log.info("Finished generating post-upgrade recovery file.");
            }
            catch (DbDumpException e) {
                this.failOnDbDumpException("Post-Upgrade", e);
            }
        }
        super.entireUpgradeFinished();
        this.eventPublisher.publish((Object)new UpgradeFinishedEvent((Object)this));
    }

    protected boolean permitDatabaseUpgrades() {
        return this.permitDatabaseUpgrades.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAcquireDatabaseUpgradesLock(int initialBuildNumber) {
        if (this.clusterManager.isClustered()) {
            ClusterLock upgradeLock = this.clusterLockService.getLockForName(CLUSTER_UPGRADE_LOCK);
            if (upgradeLock.tryLock()) {
                try {
                    if (this.neededSchemaUpgrade()) {
                        this.schemaHelper.updateVersionHistorySchemaIfNeeded();
                    }
                    String upgradeLockTag = "lock_for_upgrade_to_" + GeneralUtil.getBuildNumber();
                    log.debug("Cluster upgrade lock acquired. Attempting to tag build number {}", (Object)initialBuildNumber);
                    boolean tagSuccessful = this.versionHistoryDao.tagBuild(initialBuildNumber, upgradeLockTag);
                    if (tagSuccessful) {
                        log.debug("Successfully tagged build number {} with '{}', database upgrades are permitted", (Object)initialBuildNumber, (Object)upgradeLockTag);
                        boolean bl = true;
                        return bl;
                    }
                    log.debug("Failed to tag build number {} with '{}'", (Object)initialBuildNumber, (Object)upgradeLockTag);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    upgradeLock.unlock();
                }
            }
            log.warn("Cluster upgrade lock could not be acquired. Disallowing database upgrades on this node.");
            return false;
        }
        return true;
    }

    @VisibleForTesting
    protected void runUpgradeTasks(List<UpgradeTask> upgradeTasks) throws UpgradeException {
        super.runUpgradeTasks(upgradeTasks);
    }

    private boolean isUpgradeRecoveryFileEnabled() {
        Boolean isLicensedForDataCenter = this.licenseService.isLicensedForDataCenterOrExempt();
        Boolean enabledByDefault = isLicensedForDataCenter == false && this.permitDatabaseUpgrades();
        if (isLicensedForDataCenter.booleanValue()) {
            log.warn("Upgrade recovery file generation is disabled by default for data center license. To enable it please explicitly set parameter 'confluence.upgrade.recovery.file.enabled' as true.");
        }
        return Boolean.parseBoolean(System.getProperty("confluence.upgrade.recovery.file.enabled", enabledByDefault.toString()));
    }

    public void setCacheFlusher(CacheFlusher cacheFlusher) {
        this.cacheFlusher = cacheFlusher;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setVersionHistoryDao(VersionHistoryDao versionHistoryDao) {
        this.versionHistoryDao = versionHistoryDao;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void setClusterLockService(ClusterLockService clusterLockService) {
        this.clusterLockService = clusterLockService;
    }

    public void setUpgradeGate(UpgradeGate upgradeGate) {
        this.upgradeGate = upgradeGate;
    }

    public void setRecoveryFileGenerator(RecoveryFileGenerator recoveryFileGenerator) {
        this.recoveryFileGenerator = recoveryFileGenerator;
    }

    public void setClusterConfigurationHelper(ClusterConfigurationHelperInternal clusterConfigurationHelper) {
        this.clusterConfigurationHelper = clusterConfigurationHelper;
    }

    public void setConfluenceHome(FilesystemPath confluenceHome) {
        this.confluenceHome = confluenceHome;
    }

    public List<UpgradeHistoryService.Upgrade> getUpgradeHistory(int startIndex, int maxResults) {
        return this.versionHistoryDao.getUpgradeHistory(startIndex, maxResults).stream().map(item -> new UpgradeHistoryService.Upgrade(item.getVersionTag(), item.getBuildNumber(), DefaultUpgradeManager.instant(item.getInstallationDate()))).toList();
    }

    private static @Nullable Instant instant(@Nullable Date installationDate) {
        return installationDate == null ? null : installationDate.toInstant();
    }
}

