/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.upgradetask;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.BatchOperationManager;
import com.atlassian.confluence.impl.plugin.settings.PluginSettingRepository;
import com.atlassian.confluence.impl.settings.ConfluencePluginSettings;
import com.atlassian.confluence.setup.bandana.KeyedBandanaContext;
import com.atlassian.confluence.upgrade.AbstractUpgradeTask;
import com.atlassian.confluence.upgrade.DatabaseUpgradeTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

abstract class AbstractBandanaRemovalTask
extends AbstractUpgradeTask
implements DatabaseUpgradeTask {
    private final PlatformTransactionManager transactionManager;
    private final SessionFactory sessionFactory;
    protected final BandanaManager bandanaManager;
    protected final PluginSettingRepository repository;
    protected final BatchOperationManager batchOperationManager;
    protected final BiFunction<PluginSettingRepository, String, ConfluencePluginSettings> pluginSettingsFactory;
    protected AtomicInteger counter = new AtomicInteger();

    AbstractBandanaRemovalTask(PlatformTransactionManager transactionManager, SessionFactory sessionFactory, BandanaManager bandanaManager, PluginSettingRepository repository, BatchOperationManager batchOperationManager, BiFunction<PluginSettingRepository, String, ConfluencePluginSettings> pluginSettingsFactory) {
        this.transactionManager = transactionManager;
        this.sessionFactory = sessionFactory;
        this.bandanaManager = bandanaManager;
        this.repository = repository;
        this.batchOperationManager = batchOperationManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    protected <T> T executeInReadOnlyTransaction(Function<Session, T> function) {
        DefaultTransactionDefinition transDef = new DefaultTransactionDefinition();
        transDef.setReadOnly(true);
        TransactionTemplate template = new TransactionTemplate(this.transactionManager, (TransactionDefinition)transDef);
        return (T)template.execute(status -> {
            Session session = this.sessionFactory.getCurrentSession();
            return function.apply(session);
        });
    }

    protected Object migrateSingleKey(KeyedBandanaContext ctx, String key, ConfluencePluginSettings pluginSettings) {
        String context = ctx.getContextKey();
        Object value = this.bandanaManager.getValue((BandanaContext)ctx, key);
        if (value == null || "".equals(value)) {
            log.debug("Skipping Bandana record with key {} in context {}: value is null or empty", (Object)key, (Object)context);
            return null;
        }
        Object existingVal = pluginSettings.get(key);
        if (existingVal != null) {
            log.debug("Skipping Bandana record with key {} in context {}: value already exists", (Object)key, (Object)context);
            return null;
        }
        return pluginSettings.put(key, this.mapValue(value));
    }

    protected abstract Object mapValue(Object var1);

    public boolean runOnSpaceImport() {
        return false;
    }

    public boolean breaksBackwardCompatibility() {
        return false;
    }
}

