/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.upgradetask;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.admin.DefaultAdminTasklistManager;
import com.atlassian.confluence.core.BatchOperationManager;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.impl.plugin.settings.PluginSettingRepository;
import com.atlassian.confluence.impl.settings.ConfluencePluginSettings;
import com.atlassian.confluence.setup.bandana.KeyedBandanaContext;
import com.atlassian.confluence.setup.bandana.NoParentBandanaContext;
import com.atlassian.confluence.upgrade.upgradetask.AbstractBandanaRemovalTask;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.collections4.IterableUtils;
import org.hibernate.SessionFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class BandanaComplexTypesUpgradeTask
extends AbstractBandanaRemovalTask {
    public static final String BUILD_NUMBER = "9403";
    private final Map<String, Set<String>> contextPrefixToKeyPrefixMap;
    protected final ConfluenceJsonObjectMapper mapper = new ConfluenceJsonObjectMapper();

    public BandanaComplexTypesUpgradeTask(PlatformTransactionManager transactionManager, SessionFactory sessionFactory, BandanaManager bandanaManager, PluginSettingRepository repository, BatchOperationManager batchOperationManager) {
        this(transactionManager, sessionFactory, bandanaManager, repository, batchOperationManager, ConfluencePluginSettings::new, Map.of("_GLOBAL", Set.of("atlassian.confluence.settings", "atlassian.confluence.colour.scheme.backup"), "", Set.of("com.atlassian.confluence.plugins.doctheme", "com.atlassian.core.CustomPageSettings", "atlassian.confluence.colour.scheme"), "com.atlassian.confluence.plugins.synchrony.tasks", Set.of("taskTrackingMetadata"), DefaultAdminTasklistManager.ADMIN_TASK_DATA_NAMESPACE, Set.of("")));
    }

    @VisibleForTesting
    BandanaComplexTypesUpgradeTask(PlatformTransactionManager transactionManager, SessionFactory sessionFactory, BandanaManager bandanaManager, PluginSettingRepository repository, BatchOperationManager batchOperationManager, BiFunction<PluginSettingRepository, String, ConfluencePluginSettings> pluginSettingsFactory, Map<String, Set<String>> contextPrefixToKeyPrefixMap) {
        super(transactionManager, sessionFactory, bandanaManager, repository, batchOperationManager, pluginSettingsFactory);
        this.contextPrefixToKeyPrefixMap = contextPrefixToKeyPrefixMap;
    }

    public String getBuildNumber() {
        return BUILD_NUMBER;
    }

    public String getShortDescription() {
        return "Migrate Bandana complex types to new Plugin Settings table";
    }

    public void doUpgrade() {
        log.info("Migrating Bandana complex data to new Plugin Settings table");
        List contexts = this.executeInReadOnlyTransaction(session -> session.createQuery("SELECT DISTINCT cbr.context FROM ConfluenceBandanaRecord cbr", String.class).list());
        List<String> contextsToMigrate = Objects.requireNonNull(contexts).stream().filter(context -> this.contextPrefixToKeyPrefixMap.entrySet().stream().anyMatch(entry -> context.startsWith((String)entry.getKey()))).toList();
        contextsToMigrate.forEach(this::migrateForContext);
        log.info("Migrating Bandana complex data to new Plugin Settings table completed. Migrated {} records", (Object)this.counter.get());
    }

    public void migrateForContext(String context) {
        NoParentBandanaContext ctx = new NoParentBandanaContext(context);
        Iterable keys = this.bandanaManager.getKeys((BandanaContext)ctx);
        HashSet<String> filteredKeys = new HashSet<String>();
        for (String key : keys) {
            if (this.contextPrefixToKeyPrefixMap.entrySet().stream().noneMatch(entry -> {
                if (!context.startsWith((String)entry.getKey())) return false;
                if (!((Set)entry.getValue()).stream().anyMatch(key::startsWith)) return false;
                return true;
            })) {
                log.debug("Skipping Bandana record with key {} in context {}: key does not match any prefix", (Object)key, (Object)context);
                continue;
            }
            filteredKeys.add(key);
        }
        ConfluencePluginSettings pluginSettings = (ConfluencePluginSettings)((Object)this.pluginSettingsFactory.apply(this.repository, context));
        this.batchOperationManager.applyInBatches(filteredKeys, IterableUtils.size(filteredKeys), arg_0 -> this.lambda$migrateForContext$4((KeyedBandanaContext)ctx, pluginSettings, context, arg_0));
    }

    @Override
    protected Object mapValue(Object value) {
        return this.mapper.serialize(value);
    }

    private /* synthetic */ Object lambda$migrateForContext$4(KeyedBandanaContext ctx, ConfluencePluginSettings pluginSettings, String context, String key) {
        Object value = null;
        try {
            value = this.migrateSingleKey(ctx, key, pluginSettings);
            this.counter.incrementAndGet();
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to migrate a complex data from Bandana record with key {} in context {}", (Object)key, (Object)context);
        }
        return value;
    }
}

