/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.upgradetask;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.BatchOperationManager;
import com.atlassian.confluence.impl.plugin.settings.PluginSettingRepository;
import com.atlassian.confluence.impl.settings.ConfluencePluginSettings;
import com.atlassian.confluence.setup.bandana.KeyedBandanaContext;
import com.atlassian.confluence.setup.bandana.NoParentBandanaContext;
import com.atlassian.confluence.upgrade.upgradetask.AbstractBandanaRemovalTask;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.collections4.IterableUtils;
import org.hibernate.SessionFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class BandanaToPluginSettingsUpgradeTask
extends AbstractBandanaRemovalTask {
    public static final String BUILD_NUMBER = "9301";

    public BandanaToPluginSettingsUpgradeTask(PlatformTransactionManager transactionManager, SessionFactory sessionFactory, BandanaManager bandanaManager, PluginSettingRepository repository, BatchOperationManager batchOperationManager) {
        this(transactionManager, sessionFactory, bandanaManager, repository, batchOperationManager, ConfluencePluginSettings::new);
    }

    @VisibleForTesting
    BandanaToPluginSettingsUpgradeTask(PlatformTransactionManager transactionManager, SessionFactory sessionFactory, BandanaManager bandanaManager, PluginSettingRepository repository, BatchOperationManager batchOperationManager, BiFunction<PluginSettingRepository, String, ConfluencePluginSettings> pluginSettingsFactory) {
        super(transactionManager, sessionFactory, bandanaManager, repository, batchOperationManager, pluginSettingsFactory);
    }

    public String getBuildNumber() {
        return BUILD_NUMBER;
    }

    public String getShortDescription() {
        return "Migrate Bandana data to new Plugin Settings table";
    }

    public void doUpgrade() {
        log.info("Migrating Bandana data to new Plugin Settings table");
        Set contexts = Set.copyOf(this.executeInReadOnlyTransaction(session -> session.createQuery("SELECT DISTINCT cbr.context FROM ConfluenceBandanaRecord cbr", String.class).list()));
        Objects.requireNonNull(contexts).forEach(this::migrateForContext);
        log.info("Migrating Bandana data to new Plugin Settings table completed. Migrated {} records", (Object)this.counter.get());
    }

    public void migrateForContext(String context) {
        NoParentBandanaContext ctx = new NoParentBandanaContext(context);
        Iterable keys = this.bandanaManager.getKeys((BandanaContext)ctx);
        ConfluencePluginSettings pluginSettings = (ConfluencePluginSettings)((Object)this.pluginSettingsFactory.apply(this.repository, context));
        this.batchOperationManager.applyInBatches(keys, IterableUtils.size((Iterable)keys), arg_0 -> this.lambda$migrateForContext$1((KeyedBandanaContext)ctx, pluginSettings, context, arg_0));
    }

    @Override
    protected Object mapValue(Object value) {
        return value;
    }

    private /* synthetic */ Object lambda$migrateForContext$1(KeyedBandanaContext ctx, ConfluencePluginSettings pluginSettings, String context, String key) {
        Object oldValue = null;
        try {
            oldValue = this.migrateSingleKey(ctx, key, pluginSettings);
            this.counter.incrementAndGet();
        }
        catch (IllegalArgumentException e) {
            log.debug("Skipping Bandana record with key {} in context {}: {}", new Object[]{key, context, e.getMessage()});
        }
        return oldValue;
    }
}

