/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.upgradetask;

import com.atlassian.confluence.core.PersistentDecorator;
import com.atlassian.confluence.impl.hibernate.DataAccessUtils;
import com.atlassian.confluence.themes.persistence.PersistentDecoratorDao;
import com.atlassian.confluence.upgrade.AbstractUpgradeTask;
import com.atlassian.confluence.upgrade.DatabaseUpgradeTask;
import com.atlassian.confluence.upgrade.PersistentDecoratorUpgradeHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowCountCallbackHandler;

public class DecoratorLangMacroReplacementUpgradeTask
extends AbstractUpgradeTask
implements DatabaseUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(DecoratorLangMacroReplacementUpgradeTask.class);
    private final SessionFactory sessionFactory;
    private PersistentDecoratorDao persistentDecoratorDao;

    public DecoratorLangMacroReplacementUpgradeTask(SessionFactory sessionFactory, PersistentDecoratorDao persistentDecoratorDao) {
        this.persistentDecoratorDao = persistentDecoratorDao;
        this.sessionFactory = sessionFactory;
    }

    public String getBuildNumber() {
        return "9104";
    }

    public String getShortDescription() {
        return "Remove LangMacro references from custom decorators";
    }

    public boolean runOnSpaceImport() {
        return false;
    }

    public boolean breaksBackwardCompatibility() {
        return false;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_SPRING_JDBC"}, justification="SQL Injection is not a concern here as the query is hardcoded and not user input.")
    public void doUpgrade() throws Exception {
        log.info("DecoratorLangMacroReplacementUpgradeTask: Checking for custom decorators eligible for upgrade");
        String query = this.sessionFactory.getCurrentSession().createNativeQuery("SELECT SPACEKEY, DECORATORNAME FROM DECORATOR WHERE DECORATORNAME = 'decorators/admin.vmd' OR DECORATORNAME = 'decorators/main.vmd' OR DECORATORNAME = 'decorators/login.vmd'").getQueryString();
        JdbcTemplate jdbcTemplate = DataAccessUtils.getJdbcTemplate(this.sessionFactory.getCurrentSession());
        jdbcTemplate.query(query, (RowCallbackHandler)this.getRowCountCallbackUpgradeHandler());
        log.info("DecoratorLangMacroReplacementUpgradeTask: Finished upgrading any custom decorators eligible for upgrade");
    }

    private RowCountCallbackHandler getRowCountCallbackUpgradeHandler() {
        return new RowCountCallbackHandler(){

            public void processRow(ResultSet rs, int rowNum) throws SQLException {
                String spaceKey = rs.getString(1);
                String spaceKeySanitized = spaceKey == null ? "null" : spaceKey.replaceAll("[\r\n]", "");
                String decoratorName = rs.getString(2);
                if (decoratorName == null) {
                    log.warn("Decorator name is null for spaceKey: {} - Skipping..", (Object)spaceKeySanitized);
                    return;
                }
                decoratorName = decoratorName.replaceAll("[\r\n]", "");
                log.debug("Found custom decorator entry that might need upgrade. SpaceKey: {}, decoratorName: {}", (Object)spaceKeySanitized, (Object)decoratorName);
                PersistentDecorator decorator = DecoratorLangMacroReplacementUpgradeTask.this.persistentDecoratorDao.get(spaceKey, decoratorName);
                if (decorator == null) {
                    log.warn("Decorator not found for spaceKey: {}, decoratorName: {} - Skipping..", (Object)spaceKeySanitized, (Object)decoratorName);
                    return;
                }
                PersistentDecoratorUpgradeHelper.replaceLangMacroInDecorator(decorator);
                DecoratorLangMacroReplacementUpgradeTask.this.persistentDecoratorDao.saveOrUpdate(decorator);
                log.info("Decorator upgraded for spaceKey: {}, decoratorName: {}", (Object)spaceKeySanitized, (Object)decoratorName);
            }
        };
    }
}

