/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.upgradetask;

import com.atlassian.config.db.HibernateConfig;
import com.atlassian.confluence.upgrade.AbstractUpgradeTask;
import com.atlassian.confluence.upgrade.DatabaseUpgradeTask;
import com.atlassian.confluence.upgrade.ddl.DdlExecutor;
import com.atlassian.confluence.upgrade.ddl.DropTableIfExistsCommand;
import java.util.Collections;

public class DropIncrementalSyncSubscriptionUpgradeTask
extends AbstractUpgradeTask
implements DatabaseUpgradeTask {
    public static final String TABLE_NAME = "INCREMENTAL_SYNC_SUBSCRIPTION";
    private final DdlExecutor ddlExecutor;
    private final HibernateConfig hibernateConfig;

    public DropIncrementalSyncSubscriptionUpgradeTask(DdlExecutor ddlExecutor, HibernateConfig hibernateConfig) {
        this.ddlExecutor = ddlExecutor;
        this.hibernateConfig = hibernateConfig;
    }

    public String getBuildNumber() {
        return "9202";
    }

    public boolean runOnSpaceImport() {
        return false;
    }

    public boolean breaksBackwardCompatibility() {
        return false;
    }

    public void doUpgrade() throws Exception {
        try {
            String maybeTableName = TABLE_NAME;
            if (this.hibernateConfig.isPostgreSql()) {
                maybeTableName = TABLE_NAME.toLowerCase();
            }
            DropTableIfExistsCommand dropTableIfExistsCommand = this.ddlExecutor.createDropTableIfExistsCommand(maybeTableName);
            this.ddlExecutor.executeDdl(Collections.singletonList(dropTableIfExistsCommand));
        }
        catch (Exception e) {
            log.warn("Unexpected error occurred while dropping table {}: {}", (Object)TABLE_NAME, (Object)e.getMessage());
        }
    }
}

