/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.upgradetask;

import com.atlassian.confluence.impl.core.persistence.hibernate.schema.LabelUniqueIndexHelper;
import com.atlassian.confluence.upgrade.AbstractUpgradeTask;
import com.atlassian.confluence.upgrade.DatabaseUpgradeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelUniqueIndexUpgradeTask
extends AbstractUpgradeTask
implements DatabaseUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(LabelUniqueIndexUpgradeTask.class);
    public static final String BUILD_NUMBER = "9109";
    public static final String SKIP_LABEL_UNIQUE_INDEX_UPGRADE_TASK = "confluence.upgrade.label.unique.index.task.skipped";
    private final LabelUniqueIndexHelper labelUniqueIndexHelper;

    public LabelUniqueIndexUpgradeTask(LabelUniqueIndexHelper labelUniqueIndexHelper) {
        this.labelUniqueIndexHelper = labelUniqueIndexHelper;
    }

    public String getBuildNumber() {
        return BUILD_NUMBER;
    }

    public boolean isDatabaseUpgrade() {
        return true;
    }

    public void doUpgrade() throws Exception {
        if (this.skipped()) {
            log.info("LabelUniqueIndexUpgradeTask: skipped");
            return;
        }
        log.info("LabelUniqueIndexUpgradeTask: starting upgrade task");
        log.info("Starting cleaning up duplicated labels");
        this.labelUniqueIndexHelper.cleanUpDuplicatedLabels();
        log.info("Finished cleaning up duplicated labels");
        this.labelUniqueIndexHelper.createVirtualColumnAndUniqueIndex();
        log.info("LabelUniqueIndexUpgradeTask: upgrade task completed");
    }

    public boolean runOnSpaceImport() {
        return false;
    }

    public boolean breaksBackwardCompatibility() {
        return false;
    }

    private boolean skipped() {
        return Boolean.parseBoolean(System.getProperty(SKIP_LABEL_UNIQUE_INDEX_UPGRADE_TASK, "false"));
    }
}

