/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.upgradetask;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.impl.setup.ConfluenceApplicationConfig;
import com.atlassian.confluence.upgrade.AbstractUpgradeTask;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceState;
import java.util.Objects;

public class SecureLocalConfigSecretsUpgradeTask
extends AbstractUpgradeTask {
    private static final String BUILD_NUMBER = "9108";
    private final ApplicationConfiguration applicationConfiguration;

    public SecureLocalConfigSecretsUpgradeTask(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = Objects.requireNonNull(applicationConfiguration, "applicationConfig is required");
    }

    public boolean runOnSpaceImport() {
        return false;
    }

    public boolean breaksBackwardCompatibility() {
        return true;
    }

    public String getBuildNumber() {
        return BUILD_NUMBER;
    }

    public String getShortDescription() {
        return "Secure secrets in local config.";
    }

    public void doUpgrade() throws Exception {
        if (SecretService.getState() != SecretServiceState.ENABLED) {
            log.info("Skipping upgrade task for securing secrets in local config.");
            return;
        }
        this.upgrade();
    }

    private void upgrade() {
        try {
            this.secureLocalConfigSecrets();
        }
        catch (Exception ex) {
            throw new SecretServiceException("Failed to secure local config secrets.", (Throwable)ex);
        }
    }

    private void secureLocalConfigSecrets() throws ConfigurationException {
        log.info("Securing local config secrets now...");
        this.applicationConfiguration.load();
        ConfluenceApplicationConfig.enableSecureProperties(this.applicationConfiguration);
        this.applicationConfiguration.save();
        log.info("Local config secrets secured.");
    }
}

