/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.upgradetask;

import com.atlassian.confluence.mail.ConfluenceMailServerManager;
import com.atlassian.confluence.upgrade.AbstractUpgradeTask;
import com.atlassian.confluence.upgrade.DatabaseUpgradeTask;
import com.atlassian.mail.server.MailServer;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceState;
import java.util.Map;

public class SecureMailServerSecretUpgradeTask
extends AbstractUpgradeTask
implements DatabaseUpgradeTask {
    private static final String BUILD_NUMBER = "9105";
    private final ConfluenceMailServerManager mailServerManager;

    public boolean runOnSpaceImport() {
        return false;
    }

    public boolean breaksBackwardCompatibility() {
        return true;
    }

    public String getBuildNumber() {
        return BUILD_NUMBER;
    }

    public SecureMailServerSecretUpgradeTask(ConfluenceMailServerManager mailServerManager) {
        this.mailServerManager = mailServerManager;
    }

    public String getShortDescription() {
        return "Secure passwords for configured mail servers.";
    }

    public void doUpgrade() throws Exception {
        if (SecretService.getState() != SecretServiceState.ENABLED) {
            log.info("Skipping the securing of passwords for mail servers.");
            return;
        }
        log.info("Re-saving mail server configurations.");
        Map<Long, MailServer> serverMap = this.mailServerManager.getMailServers();
        this.mailServerManager.saveServerMap(serverMap);
        log.info("Upgrade task for securing mail server passwords is completed.");
    }
}

