/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.upgradetask;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.internal.ApplicationConfig;
import com.atlassian.confluence.cluster.DefaultClusterConfigurationHelper;
import com.atlassian.confluence.impl.setup.ConfluenceApplicationConfig;
import com.atlassian.confluence.upgrade.AbstractUpgradeTask;
import com.atlassian.confluence.upgrade.DatabaseUpgradeTask;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceState;
import java.util.Objects;
import java.util.Optional;

public class SecureSharedConfigSecretsUpgradeTask
extends AbstractUpgradeTask
implements DatabaseUpgradeTask {
    private static final String BUILD_NUMBER = "9107";
    private final DefaultClusterConfigurationHelper clusterConfigurationHelper;

    public SecureSharedConfigSecretsUpgradeTask(DefaultClusterConfigurationHelper clusterConfigurationHelper) {
        this.clusterConfigurationHelper = Objects.requireNonNull(clusterConfigurationHelper, "clusterConfigurationHelper is required");
    }

    public boolean runOnSpaceImport() {
        return false;
    }

    public boolean breaksBackwardCompatibility() {
        return true;
    }

    public String getBuildNumber() {
        return BUILD_NUMBER;
    }

    public String getShortDescription() {
        return "Secure secrets in shared config.";
    }

    public void doUpgrade() throws Exception {
        if (SecretService.getState() != SecretServiceState.ENABLED) {
            log.info("Skipping upgrade task for securing secrets in shared config.");
            return;
        }
        this.upgrade();
    }

    private void upgrade() {
        try {
            this.secureSharedConfigSecrets();
        }
        catch (Exception ex) {
            throw new SecretServiceException("Failed to secure shared config secrets.", (Throwable)ex);
        }
    }

    private void secureSharedConfigSecrets() throws ConfigurationException {
        Optional<ApplicationConfig> maybeSharedConfig = this.clusterConfigurationHelper.getClusterApplicationConfig();
        if (maybeSharedConfig.isPresent()) {
            log.info("Securing shared config secrets now...");
            ApplicationConfig sharedConfig = maybeSharedConfig.get();
            sharedConfig.load();
            ConfluenceApplicationConfig.enableSecureProperties((ApplicationConfiguration)sharedConfig);
            sharedConfig.save();
            log.info("Shared config secrets secured.");
        }
    }
}

