/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade.upgradetask;

import com.atlassian.confluence.upgrade.AbstractUpgradeTask;
import com.atlassian.confluence.upgrade.DatabaseUpgradeTask;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.util.List;

public class UserDirectoryPasswordEncryptionUpgradeTask
extends AbstractUpgradeTask
implements DatabaseUpgradeTask {
    public static final String DISABLE_UPGRADE_TASK_FLAG = "confluence.upgrade.user-directory-password-encryption-upgrade-task.disable";
    private final DirectoryDao directoryDao;
    private static final String BUILD_NUMBER = "9103";

    public UserDirectoryPasswordEncryptionUpgradeTask(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }

    public boolean runOnSpaceImport() {
        return false;
    }

    public boolean breaksBackwardCompatibility() {
        return true;
    }

    public String getBuildNumber() {
        return BUILD_NUMBER;
    }

    public String getShortDescription() {
        return "Encrypt passwords for configured user directories.";
    }

    public void doUpgrade() throws Exception {
        if (Boolean.getBoolean(DISABLE_UPGRADE_TASK_FLAG)) {
            log.info("Skipping password encryption for user directories task.");
            return;
        }
        this.upgrade();
    }

    private void upgrade() {
        List<Directory> userDirectories = this.getAllUserDirectories();
        if (!userDirectories.isEmpty()) {
            log.info("Re-saving user directories using [{}]. User directory count: [{}].", (Object)this.directoryDao.getClass().getSimpleName(), (Object)userDirectories.size());
            userDirectories.forEach(directory -> {
                try {
                    this.directoryDao.update(directory);
                    log.info("Re-saved directory [{}].", (Object)directory.getId());
                }
                catch (DirectoryNotFoundException e) {
                    log.error("Re-saving directory [{}] failed. Error message: {}", (Object)directory.getId(), (Object)e.getMessage());
                }
            });
            log.info("User directory password encryption upgrade task completed.");
        }
    }

    private List<Directory> getAllUserDirectories() {
        return this.directoryDao.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
    }
}

