/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import com.atlassian.user.User;
import com.google.common.base.Throwables;
import java.util.Map;
import java.util.concurrent.Callable;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum AuthenticatedUserImpersonator {
    REQUEST_AWARE,
    REQUEST_AGNOSTIC{

        @Override
        protected <T> Callable<T> wrapCallback(Callable<T> callback) {
            return () -> AuthenticatedUserImpersonator.hideRequestCache(callback);
        }
    };


    public <T> T asAnonymousUser(Callable<T> callback) {
        return this.asUser(callback, (ConfluenceUser)null);
    }

    public <T> T asUser(Callable<T> callback, @Nullable ConfluenceUser user) {
        try {
            return (T)this.wrapCallback(() -> AuthenticatedUserThreadLocal.asUser(user, callback)).call();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Deprecated(forRemoval=true)
    public <T> T asUser(Callable<T> callback, @Nullable User user) {
        return this.asUser(callback, FindUserHelper.getUser(user));
    }

    protected <T> Callable<T> wrapCallback(Callable<T> callback) {
        return callback;
    }

    private static <T> T hideRequestCache(Callable<T> callback) throws Exception {
        Map requestCache = RequestCacheThreadLocal.getRequestCache();
        try {
            RequestCacheThreadLocal.clearRequestCache();
            T t = callback.call();
            return t;
        }
        finally {
            RequestCacheThreadLocal.setRequestCache(requestCache);
        }
    }
}

