/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserResolver;
import com.atlassian.confluence.user.UserForm;
import com.atlassian.confluence.user.UserFormValidator;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.validation.MessageHolder;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserFormValidator
implements UserFormValidator {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserFormValidator.class);
    private static final String ENGLISH_ANONYMOUS_USER = "anonymous";
    private final ConfluenceUserResolver confluenceUserResolver;
    private final I18NBeanFactory i18NBeanFactory;
    private final CrowdDirectoryService crowdDirectoryService;
    private final DirectoryManager directoryManager;

    public DefaultUserFormValidator(ConfluenceUserResolver confluenceUserResolver, I18NBeanFactory i18NBeanFactory, CrowdDirectoryService crowdDirectoryService, DirectoryManager directoryManager) {
        this.confluenceUserResolver = confluenceUserResolver;
        this.i18NBeanFactory = i18NBeanFactory;
        this.crowdDirectoryService = crowdDirectoryService;
        this.directoryManager = directoryManager;
    }

    @Override
    public MessageHolder validateNewUserBySignup(UserForm form, MessageHolder result) {
        this.safePut("username", this.validateUsername(form.getUsername()), result);
        this.safePut("fullName", this.validateFullName(form.getFullName()), result);
        this.safePut("email", this.validateEmail(form.getEmail()), result);
        this.validatePassword(form.getPassword(), form.getConfirm(), result);
        return result;
    }

    @Override
    public MessageHolder validateEditUser(UserForm form, MessageHolder result) {
        if (this.confluenceUserResolver.getUserByName(form.getUsername()) == null) {
            result.addActionError("user.doesnt.exist");
        }
        this.safePut("fullName", this.validateFullName(form.getFullName()), result);
        this.safePut("email", this.validateEmail(form.getEmail()), result);
        return result;
    }

    @Override
    public MessageHolder validateEditUserAllowRename(UserForm form, MessageHolder result) {
        ConfluenceUser user = this.confluenceUserResolver.getExistingUserByKey(form.getUserKey());
        if (user == null) {
            result.addActionError("user.doesnt.exist");
        } else if (!user.getName().equals(form.getUsername())) {
            this.safePut("username", this.validateNewUsername(form.getUsername(), -1L), result);
        }
        this.safePut("fullName", this.validateFullName(form.getFullName()), result);
        this.safePut("email", this.validateEmail(form.getEmail()), result);
        return result;
    }

    @Override
    public MessageHolder validateNewUser(UserForm form, MessageHolder result) {
        String usernameError = this.validateNewUsername(form.getUsername(), form.getDirectoryId());
        this.safePut("username", usernameError, result);
        this.safePut("fullName", this.validateFullName(form.getFullName()), result);
        this.safePut("email", this.validateEmail(form.getEmail()), result);
        this.validatePassword(form.getPassword(), form.getConfirm(), result);
        this.safePut("directoryId", this.validateDirectory(usernameError, form.getUsername(), form.getDirectoryId()), result);
        return result;
    }

    private String validateNewUsername(String username, long directoryId) {
        if (directoryId <= 0L && this.confluenceUserResolver.getUserByName(username) != null) {
            return "user.exists";
        }
        return this.validateUsername(username);
    }

    private void safePut(String field, String error, MessageHolder result) {
        if (StringUtils.isNotBlank((CharSequence)error)) {
            result.addFieldError(field, error);
        }
    }

    private String validateUsername(String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return "username.empty";
        }
        if (StringUtils.containsAny((CharSequence)username, (CharSequence)"\\,+<>'\"")) {
            return "username.invalid";
        }
        if (!username.matches("\\S+")) {
            return "username.no.whitespace";
        }
        if (this.getI18NBean().getText("anonymous.name").equalsIgnoreCase(username) || ENGLISH_ANONYMOUS_USER.equalsIgnoreCase(username)) {
            return "reserved.username";
        }
        if (!username.equals(username.toLowerCase())) {
            return "username.uppercase";
        }
        return null;
    }

    private I18NBean getI18NBean() {
        return this.i18NBeanFactory.getI18NBean();
    }

    private void validatePassword(String password, String confirm, MessageHolder result) {
        if (StringUtils.isBlank((CharSequence)password)) {
            result.addFieldError("password", "password.empty");
        } else if (!password.equals(confirm)) {
            result.addFieldError("confirm", "passwords.dontmatch");
        }
    }

    private String validateEmail(String email) {
        if (StringUtils.isBlank((CharSequence)email) || !EmailValidator.getInstance().isValid(email)) {
            return "email.invalid";
        }
        return null;
    }

    private String validateFullName(String fullName) {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            return "fullname.empty";
        }
        if (StringUtils.containsAny((CharSequence)fullName, (CharSequence)"<>")) {
            return "signup.fullname.contains.angle.bracket";
        }
        if (this.getI18NBean().getText("anonymous.name").equalsIgnoreCase(fullName) || ENGLISH_ANONYMOUS_USER.equalsIgnoreCase(fullName)) {
            return "reserved.fullname";
        }
        return null;
    }

    private String validateDirectory(String usernameError, String username, long directoryId) {
        if (directoryId <= 0L) {
            return null;
        }
        if (usernameError != null) {
            return null;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(directoryId);
        if (directory == null) {
            return "embedded.crowd.directory.not.found";
        }
        if (!directory.isActive()) {
            return "user.directory.not.active";
        }
        try {
            if (this.directoryManager.findUserByName(directoryId, username) != null) {
                return "user.exists.in.directory";
            }
            return null;
        }
        catch (DirectoryNotFoundException e) {
            return "embedded.crowd.directory.not.found";
        }
        catch (UserNotFoundException e) {
            return null;
        }
        catch (OperationFailedException e) {
            log.error("Unable to check for user", (Throwable)e);
            return "create.user.internal.error";
        }
    }
}

