/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;

public final class LoginDetailsHelper {
    public static final String DIRECT_LOGIN = "com.atlassian.confluence.login.direct";
    private static final String SSO_LOGIN = "com.atlassian.plugins.authentication.userLoggedInWithSso";
    private static final String TWOSV_COMPATIBLE_LOGIN = "com.atlassian.plugins.authentication.2sv.login";

    private LoginDetailsHelper() {
    }

    public static boolean isDirectLogin(HttpServletRequest request) {
        Boolean directObj = (Boolean)request.getAttribute(DIRECT_LOGIN);
        return Boolean.TRUE.equals(directObj);
    }

    public static boolean isSsoLogin(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        Boolean ssoLoginObj = (Boolean)request.getSession().getAttribute(SSO_LOGIN);
        return Boolean.TRUE.equals(ssoLoginObj);
    }

    public static boolean isTwosvCompatibleLogin(HttpServletRequest httpServletRequest) {
        return Objects.equals(httpServletRequest.getAttribute(TWOSV_COMPATIBLE_LOGIN), true);
    }
}

