/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.core.filters.ServletContextThreadLocal;
import jakarta.servlet.http.HttpSession;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserInterfaceState {
    private static final Logger log = LoggerFactory.getLogger(UserInterfaceState.class);
    public static final int DEFAULT_MAX_RECENTLY_UPDATED_PAGE_COUNT = 20;
    public static final int LIMIT_MAX_RECENTLY_UPDATED_PAGE_COUNT = 50;
    public static final int STEP_SIZE_RECENTLY_UPDATED_PAGE_COUNT = 10;
    public static final int LIMIT_MIN_RECENTLY_UPDATED_PAGE_COUNT = 10;
    private final ConfluenceUser user;
    private Boolean attachmentsShowing;
    private Boolean childrenShowing;
    private int recentChangesSize;
    private final UserAccessor userAccessor;

    public UserInterfaceState(@Nullable ConfluenceUser user, UserAccessor userAccessor) {
        this.user = user;
        this.userAccessor = userAccessor;
    }

    public Boolean getAttachmentsShowing() {
        if (this.attachmentsShowing == null) {
            this.attachmentsShowing = this.getBooleanFromSessionOrUserPrefs("confluence.show.attachments", "confluence.user.runtime.show-attachments").orElse(true);
        }
        return this.attachmentsShowing;
    }

    public void setAttachmentsShowing(Boolean attachmentsShowing) {
        this.setBooleanInSessionAndUserPrefs(attachmentsShowing, "confluence.show.attachments", "confluence.user.runtime.show-attachments");
    }

    public Boolean getChildrenShowing() {
        if (this.childrenShowing == null) {
            this.childrenShowing = this.getBooleanFromSessionOrUserPrefs("confluence.show.children", "confluence.user.runtime.show-children").orElse(true);
        }
        return this.childrenShowing;
    }

    public void setChildrenShowing(Boolean childrenShowing) {
        this.setBooleanInSessionAndUserPrefs(childrenShowing, "confluence.show.children", "confluence.user.runtime.show-children");
    }

    public void setRecentChangesSize(int recentChangesSize) {
        this.setIntInSessionAndUserPrefs(recentChangesSize, "confluence.recentchanges.size", "confluence.user.runtime.recent-changes.size");
    }

    public void setDashboardSpacesTab(String dashboardTab) {
        this.setStringInSessionAndUserPrefs(dashboardTab, "confluence.dashboard.spaces.selected.tab", "confluence.user.dashboard.spaces.selected.tab");
    }

    public String getDashboardSpacesTab() {
        return this.getStringFromSessionOrUserPrefs("confluence.dashboard.spaces.selected.tab", "confluence.user.dashboard.spaces.selected.tab").orElse(null);
    }

    public void setDashboardSpacesSelectedTeam(String selectedTeam) {
        this.setStringInSessionAndUserPrefs(selectedTeam, "confluence.dashboard.spaces.selected.team", "confluence.user.dashboard.spaces.selected.team");
    }

    public String getDashboardSpacesSelectedTeam() {
        return this.getStringFromSessionOrUserPrefs("confluence.dashboard.spaces.selected.team", "confluence.user.dashboard.spaces.selected.team").orElse(null);
    }

    public int getRecentChangesSize() {
        if (this.recentChangesSize == 0) {
            this.recentChangesSize = this.getIntegerFromSessionOrUserPrefs("confluence.recentchanges.size", "confluence.user.runtime.recent-changes.size").orElse(0);
        }
        return this.recentChangesSize;
    }

    private void setBooleanInSessionAndUserPrefs(Boolean value, String sessionKey, String userPrefsKey) {
        this.putInSession(sessionKey, value);
        if (this.user != null) {
            this.prefs().setBoolean(userPrefsKey, value);
        }
    }

    private Optional<Boolean> getBooleanFromSessionOrUserPrefs(String sessionKey, String userPrefsKey) {
        return this.getFromSession(sessionKey, Boolean.class).or(() -> this.prefs().getBoolean(userPrefsKey));
    }

    private void setIntInSessionAndUserPrefs(int value, String sessionKey, String userPrefsKey) {
        this.putInSession(sessionKey, value);
        if (this.user != null) {
            this.prefs().setLong(userPrefsKey, value);
        }
    }

    private Optional<Integer> getIntegerFromSessionOrUserPrefs(String sessionKey, String userPrefsKey) {
        return this.getFromSession(sessionKey, Number.class).or(() -> this.prefs().getLong(userPrefsKey)).map(Number::intValue);
    }

    private Optional<String> getStringFromSessionOrUserPrefs(String sessionKey, String userPrefsKey) {
        return this.getFromSession(sessionKey, String.class).or(() -> this.prefs().getString(userPrefsKey));
    }

    private UserPreferences prefs() {
        return this.userAccessor.getUserPreferences(this.user);
    }

    private void setStringInSessionAndUserPrefs(String value, String sessionKey, String userPrefsKey) {
        this.putInSession(sessionKey, value);
        if (this.user != null) {
            this.prefs().setString(userPrefsKey, value);
        }
    }

    private <T> Optional<T> getFromSession(String sessionKey, Class<T> type) {
        HttpSession session = ServletContextThreadLocal.getRequest().getSession();
        if (session != null) {
            return Optional.ofNullable(type.cast(session.getAttribute(sessionKey)));
        }
        log.info("Unable to retrieve preference {} from session: session not available", (Object)sessionKey);
        return Optional.empty();
    }

    private void putInSession(String sessionKey, Object value) {
        HttpSession session = ServletContextThreadLocal.getRequest().getSession();
        if (session != null) {
            session.setAttribute(sessionKey, value);
        } else {
            log.warn("Unable to save preference {} in session: session not available", (Object)sessionKey);
        }
    }

    public int getMaxRecentChangesSize() {
        return this.ensureValidMaxRecentChangesSize(this.getRecentChangesSize());
    }

    public void setMaxRecentChangesSize(int i) {
        int sanitisedMaxChangesSize = this.ensureValidMaxRecentChangesSize(i);
        if (sanitisedMaxChangesSize == i) {
            this.setRecentChangesSize(i);
        }
    }

    private int ensureValidMaxRecentChangesSize(int i) {
        if (i < 10) {
            i = 20;
        } else if (i > 50) {
            i = 20;
        }
        return this.roundToNearest(i, 10);
    }

    private int roundToNearest(int count, int stepSize) {
        int remainder = count % stepSize;
        return Math.max(count - remainder, stepSize);
    }
}

