/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.LocaleParser;
import java.util.Locale;
import java.util.Optional;

public interface UserPreferences {
    public Optional<String> getString(String var1);

    public Optional<Boolean> getBoolean(String var1);

    public Optional<Long> getLong(String var1);

    public void setString(String var1, String var2);

    public void setLong(String var1, long var2);

    public void setBoolean(String var1, boolean var2);

    public void remove(String var1);

    default public TimeZone getTimeZone() {
        return this.getString("confluence.user.time.zone").map(TimeZone::getInstance).orElse(TimeZone.getDefault());
    }

    default public Locale getLocale() {
        return this.getString("confluence.user.locale").map(LocaleParser::toLocale).orElse(null);
    }

    default public boolean isShowDifferencesInNotificationEmails() {
        return this.getBoolean("confluence.prefs.email.show.diff").orElse(false);
    }

    default public boolean isWatchingOwnContent() {
        return this.getBoolean("confluence.prefs.watch.my.own.content").orElse(false);
    }

    public static class PreferenceException
    extends RuntimeException {
        public PreferenceException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

