/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.user.UserProfilePictureUpdateEvent;
import com.atlassian.confluence.impl.user.UserProfilePictureAccessorInternal;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.user.ConfluenceLocalAvatarFactory;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.ThreadLocalProfilePictureCache;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.user.UserPreferencesAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.confluence.user.avatar.AvatarProviderAccessor;
import com.atlassian.confluence.user.avatar.ConfluenceAvatarOwner;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.avatar.Avatar;
import com.atlassian.plugins.avatar.AvatarOwner;
import com.atlassian.user.User;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

final class UserProfilePictureAccessorImpl
implements UserProfilePictureAccessorInternal {
    private final AvatarProviderAccessor avatarProviderAccessor;
    private final PlatformTransactionManager transactionManager;
    private final UserPreferencesAccessor userPreferencesAccessor;
    private final EventPublisher eventPublisher;
    private final ConfluenceLocalAvatarFactory localAvatarFactory;

    public UserProfilePictureAccessorImpl(AvatarProviderAccessor avatarProviderAccessor, PlatformTransactionManager transactionManager, UserPreferencesAccessor userPreferencesAccessor, EventPublisher eventPublisher, ConfluenceLocalAvatarFactory localAvatarFactory) {
        this.avatarProviderAccessor = Objects.requireNonNull(avatarProviderAccessor);
        this.transactionManager = Objects.requireNonNull(transactionManager);
        this.userPreferencesAccessor = userPreferencesAccessor;
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.localAvatarFactory = Objects.requireNonNull(localAvatarFactory);
    }

    @Override
    public ProfilePictureInfo getUserProfilePicture(@Nullable User user) {
        ProfilePictureInfo cachedProfilePictureInfo = ThreadLocalProfilePictureCache.hasProfilePicture(user);
        if (cachedProfilePictureInfo != null) {
            return cachedProfilePictureInfo;
        }
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setPropagationBehavior(0);
        return (ProfilePictureInfo)new TransactionTemplate(this.transactionManager, (TransactionDefinition)definition).execute(transactionStatus -> {
            ProfilePictureInfo profilePictureInfo = this.getLogoForUser(user);
            ThreadLocalProfilePictureCache.cacheHasProfilePicture(user, profilePictureInfo);
            return profilePictureInfo;
        });
    }

    private ProfilePictureInfo getLogoForUser(@Nullable User user) {
        Avatar avatar = this.avatarProviderAccessor.getAvatarProvider().getAvatar((AvatarOwner)new ConfluenceAvatarOwner(user), this.localAvatarFactory::getConfluenceLocalAvatar, 48);
        return new ProfilePictureInfo(avatar);
    }

    @Override
    public void setUserProfilePicture(User user, String imagePath) {
        this.storePreference(user, imagePath, new UserProfilePictureUpdateEvent((Object)this, user, imagePath));
    }

    @Override
    public void setUserProfilePicture(User user, Attachment attachment) {
        ContentEntityObject container = attachment.getContainer();
        if (!(container instanceof PersonalInformation)) {
            throw new IllegalArgumentException("Attachment does not belong to a personal information object. Attachment owner is: " + String.valueOf(container));
        }
        PersonalInformation pi = (PersonalInformation)container;
        if (!pi.belongsTo(user)) {
            throw new IllegalArgumentException("Profile picture belongs to a different user. Needed user: " + String.valueOf(user) + " attachment belongs to " + pi.getUsername());
        }
        this.storePreference(user, attachment.getFileName(), new UserProfilePictureUpdateEvent((Object)this, user, attachment));
    }

    private void storePreference(User user, String path, Object event) {
        try {
            this.userPreferencesAccessor.getUserPreferences(FindUserHelper.getUser(user)).setString("confluence.user.profile.picture", path);
            this.eventPublisher.publish(event);
        }
        catch (UserPreferences.PreferenceException e) {
            throw new RuntimeException(e);
        }
    }
}

