/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.languages.BrowserLanguageUtils;
import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.languages.LocaleParser;
import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.security.login.LoginPageFunctionalityService;
import com.atlassian.confluence.upgrade.UpgradeManager;
import com.atlassian.confluence.user.SignupManager;
import com.atlassian.confluence.user.actions.AbstractUsersAction;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.MobileUtils;
import com.atlassian.confluence.util.UserAgentUtil;
import com.atlassian.confluence.web.Cookies;
import com.atlassian.core.util.XMLUtils;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public abstract class AbstractLoginSignupAction
extends AbstractUsersAction {
    private boolean fromNotPermitted;
    protected UpgradeManager upgradeManager;
    protected SignupManager signupManager;
    protected String token;
    protected LoginPageFunctionalityService loginPageFunctionalityService;
    private boolean logout;
    protected String os_destination;
    private ClusterManager clusterManager;
    private CaptchaManager captchaManager;
    private String language;

    public boolean isFromNotPermitted() {
        return this.fromNotPermitted;
    }

    @StrutsParameter
    public void setFromNotPermitted(boolean fromNotPermitted) {
        this.fromNotPermitted = fromNotPermitted;
    }

    public boolean isShowSignUp() {
        return this.loginPageFunctionalityService.isShowSignUp(this.token);
    }

    public String getSignupURL() {
        return this.loginPageFunctionalityService.getSignupURL();
    }

    @Override
    public String doDefault() throws Exception {
        if (this.language != null && this.languageManager.getLanguage(this.language) != null) {
            this.setI18NBean(this.i18NBeanFactory.getI18NBean(LocaleParser.toLocale(this.language)));
            this.localeManager.setLanguage(this.language);
            Cookies.setResponseCookie("confluence-language", this.language);
        }
        return super.doDefault();
    }

    protected Map<String, Object> commonActionViewDataMappings() {
        return ImmutableMap.builder().put((Object)"isShowSignUp", (Object)this.isShowSignUp()).put((Object)"isMobileAppWebView", (Object)this.isMobileAppWebView()).put((Object)"getActionName", (Object)this.getActionName()).put((Object)"siteTitle", (Object)(this.getGlobalSettings() == null ? "" : this.getGlobalSettings().getSiteTitle())).put((Object)"fromNotPermitted", (Object)this.isFromNotPermitted()).put((Object)"shouldShowMobileBanner", (Object)this.shouldShowMobileBanner()).put((Object)"webInterfaceContext", (Object)this.getWebInterfaceContext()).put((Object)"isBrowserLanguageEnabled", (Object)this.isBrowserLanguageEnabled()).put((Object)"languages", this.languageManager == null ? "" : this.languageManager.getLanguages()).put((Object)"authenticatedUser", this.getAuthenticatedUser() != null ? this.getAuthenticatedUser() : "").put((Object)"htmlEncodeAndReplaceSpaces_AuthenticatedUser", (Object)HtmlUtil.htmlEncodeAndReplaceSpaces(this.getAuthenticatedUser() != null ? this.getAuthenticatedUser().getName() : "")).put((Object)"generateCaptchaId", (Object)(this.getCaptchaManager() == null ? "" : this.getCaptchaManager().generateCaptchaId())).put((Object)"shouldRememberMeCheckboxBeOmitted", this.getClusterManager() == null ? "" : Boolean.valueOf(this.shouldRememberMeCheckboxBeOmitted())).put((Object)"refineOsDestination", (Object)AbstractLoginSignupAction.refineOsDestination(this.getOs_destination())).put((Object)"getSignupURL", (Object)(this.webInterfaceManager == null ? "" : this.getSignupURL())).put((Object)"showCaptchaForCurrentUser", this.getCaptchaManager() == null ? "" : Boolean.valueOf(this.getCaptchaManager().showCaptchaForCurrentUser())).build();
    }

    public void setUpgradeManager(UpgradeManager upgradeManager) {
        this.upgradeManager = upgradeManager;
    }

    public void setSignupManager(SignupManager signupManager) {
        this.signupManager = signupManager;
    }

    public String getToken() {
        return this.token;
    }

    @StrutsParameter
    public void setToken(String token) {
        this.token = token;
    }

    public boolean isLogout() {
        return this.logout;
    }

    @StrutsParameter
    public void setLogout(boolean logout) {
        this.logout = logout;
    }

    public String getOs_destination() {
        return this.os_destination;
    }

    @StrutsParameter
    public void setOs_destination(String os_destination) {
        this.os_destination = os_destination;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void setCaptchaManager(CaptchaManager captchaManager) {
        this.captchaManager = captchaManager;
    }

    public CaptchaManager getCaptchaManager() {
        return this.captchaManager;
    }

    public boolean isBrowserLanguageEnabled() {
        return BrowserLanguageUtils.isBrowserLanguageEnabled() && !this.isMobileAppWebView();
    }

    public String getLanguage() {
        return this.language;
    }

    @StrutsParameter
    public void setLanguage(String language) {
        this.language = language;
    }

    public List<Language> getLanguages() {
        return this.languageManager.getLanguages();
    }

    public void setLoginPageFunctionalityService(LoginPageFunctionalityService loginPageFunctionalityService) {
        this.loginPageFunctionalityService = loginPageFunctionalityService;
    }

    public boolean shouldRememberMeCheckboxBeOmitted() {
        return !this.loginPageFunctionalityService.shouldIncludeRememberMe();
    }

    public boolean isMobileAppWebView() {
        return UserAgentUtil.isBrowserFamily((UserAgentUtil.BrowserFamily)UserAgentUtil.BrowserFamily.ATLASSIAN_MOBILE);
    }

    public boolean shouldShowMobileBanner() {
        return MobileUtils.shouldShowBanner(this.getActiveRequest());
    }

    @HtmlSafe
    public static String refineOsDestination(String osDestination) {
        return XMLUtils.escape((String)StringUtils.defaultString((String)osDestination)).replaceAll("\\s", "%20").replace("&amp;", "&");
    }
}

