/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.event.events.security.LogoutEvent;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationHelper {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationHelper.class);

    public static boolean userLogout(Principal user, HttpServletRequest request, HttpServletResponse response, EventPublisher eventPublisher, Object source) {
        return AuthenticationHelper.logout(user, request, response, eventPublisher, source, true);
    }

    public static boolean systemLogout(Principal user, HttpServletRequest request, HttpServletResponse response, EventPublisher eventPublisher, Object source) {
        return AuthenticationHelper.logout(user, request, response, eventPublisher, source, false);
    }

    private static boolean logout(Principal user, HttpServletRequest request, HttpServletResponse response, EventPublisher eventPublisher, Object source, boolean userInitiatedLogout) {
        try {
            Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
            boolean logoutSuccessful = authenticator.logout(request, response);
            if (!logoutSuccessful) {
                return false;
            }
            if (user != null) {
                HttpSession session = request.getSession();
                LogoutEvent logoutEvent = userInitiatedLogout ? new LogoutEvent(source, user.getName(), session.getId(), request.getRemoteHost(), request.getRemoteAddr()) : new LogoutEvent(source, user.getName(), session.getId());
                eventPublisher.publish((Object)logoutEvent);
            }
            AuthenticationHelper.invalidateSession(request);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    private static void invalidateSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        AuthenticationHelper.clearUnsafeValuesFromSession(session);
        if (Boolean.getBoolean("com.atlassian.logout.invalidatesession")) {
            log.warn("System property 'com.atlassian.logout.invalidatesession' no longer has any effect. Sessions are invalidated by default. You can remove it from your configuration.");
        }
        if (!Boolean.getBoolean("com.atlassian.logout.disable.session.invalidation")) {
            try {
                session.invalidate();
            }
            catch (IllegalStateException ex) {
                log.debug("Cannot invalidate already invalid session");
            }
        }
    }

    private static void clearUnsafeValuesFromSession(HttpSession session) {
        try {
            AuthenticationHelper.getNonSeraphAttributeKeys(session).forEach(arg_0 -> ((HttpSession)session).removeAttribute(arg_0));
        }
        catch (IllegalStateException ex) {
            log.debug("Failed to clear unsafe values from session - session is already invalid");
        }
    }

    private static List<String> getNonSeraphAttributeKeys(HttpSession session) {
        ArrayList attributeNames = Collections.list(session.getAttributeNames());
        return attributeNames.stream().filter(key -> {
            if (!key.startsWith("seraph")) {
                if (log.isDebugEnabled()) {
                    log.debug("Removing value from session on logout: {} value: {}", key, session.getAttribute(key));
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("Not removing seraph value from session on logout: {} value: {}", key, session.getAttribute(key));
            }
            return false;
        }).collect(Collectors.toList());
    }

    public static String getLoginUrl() {
        HttpServletRequest request = new StaticHttpContext().getActiveRequest();
        String contextPath = StringUtils.defaultString((String)request.getContextPath());
        String loginURL = SeraphUtils.getLoginURL(request);
        if (log.isDebugEnabled()) {
            log.debug("Seraph login.url is {}", (Object)loginURL);
        }
        if (StringUtils.isNotEmpty((CharSequence)contextPath) && StringUtils.defaultString((String)loginURL).startsWith(contextPath)) {
            loginURL = loginURL.substring(contextPath.length());
        }
        return loginURL;
    }
}

