/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.Evented;
import com.atlassian.confluence.event.events.user.ConfirmEmailAddressEvent;
import com.atlassian.confluence.event.events.user.UserSignupEvent;
import com.atlassian.confluence.license.exception.LicenseUserLimitExceededException;
import com.atlassian.confluence.struts.soy.ActionViewData;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.SignupManager;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.impl.DefaultUser;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@UnrestrictedAccess
public class ConfirmEmailAction
extends ConfluenceActionSupport
implements Evented<UserSignupEvent> {
    private SignupManager signupManager;
    private CrowdService crowdService;
    private String token;
    private String username;

    @ActionViewData
    public String getLinkLoginURL() {
        return SeraphUtils.getLinkLoginURL(this.getActiveRequest(), this.username);
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        DefaultUser atlUser;
        User user = this.crowdService.getUser(this.username);
        if (user != null && this.signupManager.isTokenForUserValid((com.atlassian.user.User)(atlUser = new DefaultUser(user.getName(), user.getDisplayName(), user.getEmailAddress())), this.token)) {
            try {
                this.signupManager.enableConfirmedUser((com.atlassian.user.User)atlUser);
            }
            catch (LicenseUserLimitExceededException e) {
                this.addActionError(this.getText("not.licensed"), this.getContactAdminUrl());
                return "error";
            }
            return "success";
        }
        this.addActionError(this.getText("easyuser.invalid.token.for.given.username"));
        return "error";
    }

    private String[] getContactAdminUrl() {
        return new String[]{this.getBootstrapStatusProvider().getWebAppContextPath() + "/administrators.action"};
    }

    @StrutsParameter
    public void setToken(String token) {
        this.token = token;
    }

    @StrutsParameter
    public void setUsername(String username) {
        this.username = username;
    }

    public void setSignupManager(SignupManager signupManager) {
        this.signupManager = signupManager;
    }

    @Override
    public boolean isPermitted() {
        return true;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Override
    public UserSignupEvent getEventToPublish(String result) {
        if ("success".equals(result)) {
            ConfluenceUser user = this.userAccessor.getUserByName(this.username);
            return new ConfirmEmailAddressEvent(this, user);
        }
        return null;
    }
}

