/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.core.actions.Tabbed;
import com.atlassian.confluence.dmz.user.UserAccessorInternal;
import com.atlassian.confluence.event.Evented;
import com.atlassian.confluence.event.events.user.AdminAddedUserEvent;
import com.atlassian.confluence.license.exception.LicenseUserLimitExceededException;
import com.atlassian.confluence.struts.flash.FlashScope;
import com.atlassian.confluence.user.UserForm;
import com.atlassian.confluence.user.UserFormValidator;
import com.atlassian.confluence.user.actions.SearchUsersAction;
import com.atlassian.confluence.util.PasswordPolicyErrorMessageHelper;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.security.password.Credential;
import java.util.UUID;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdminOnly
@ReadOnlyAccessAllowed
public class CreateUserAction
extends SearchUsersAction
implements Tabbed,
Evented<AdminAddedUserEvent> {
    private static final Logger log = LoggerFactory.getLogger(CreateUserAction.class);
    public static final String SEND_EMAIL = "sendEmail";
    protected String password;
    protected String confirm;
    protected String email;
    protected String fullName;
    protected boolean sendEmail;
    private UserFormValidator validator;
    private User newUser;
    private Directory directory;
    private long directoryId;
    private UserAccessorInternal userAccessorInternal;

    @Override
    public void validate() {
        UserForm form;
        if (this.sendEmail) {
            this.confirm = null;
            this.password = null;
            String fakePassword = UUID.randomUUID().toString();
            form = new UserForm(this.username, this.fullName, this.email, fakePassword, fakePassword, this.directoryId);
        } else {
            form = new UserForm(this.username, this.fullName, this.email, this.password, this.confirm, this.directoryId);
        }
        this.validator.validateNewUser(form, this.messageHolder);
    }

    @Override
    public String execute() {
        try {
            this.setSendEmailDefault(this.sendEmail);
            String passwordToSet = this.password;
            if (this.sendEmail) {
                this.confirm = null;
                this.password = null;
                passwordToSet = UUID.randomUUID().toString();
            }
            if (this.getDirectory() != null) {
                UserTemplateWithAttributes userTemplate = new UserTemplateWithAttributes(this.username, this.directoryId);
                userTemplate.setDisplayName(this.fullName);
                userTemplate.setEmailAddress(this.email);
                userTemplate.setActive(true);
                this.newUser = this.userAccessorInternal.createUser(userTemplate, Credential.unencrypted((String)passwordToSet));
            } else {
                DefaultUser user = new DefaultUser(this.username, this.fullName, this.email);
                this.newUser = this.userAccessor.createUser((User)user, Credential.unencrypted((String)passwordToSet));
            }
            if (this.newUser != null) {
                this.userAccessor.addMembership(this.userAccessor.getNewUserDefaultGroupName(), this.username);
            } else {
                FlashScope.put("user.created.message", Message.getInstance((String)"user.created.in.directory", (Object[])new Object[]{this.getDirectory().getName()}));
            }
        }
        catch (LicenseUserLimitExceededException e) {
            this.addActionError(this.getLicenseErrorHtml());
            return "error";
        }
        catch (InfrastructureException e) {
            if (PasswordPolicyErrorMessageHelper.isInvalidCredentialExceptionDueToPasswordPolicy((Exception)((Object)e))) {
                this.addActionError(PasswordPolicyErrorMessageHelper.getPasswordPolicyErrorMessage((Exception)((Object)e)));
            } else {
                this.addActionError("create.user.failed", this.username);
            }
            log.error("Failed to create user: {}", (Object)this.user, (Object)e);
            return "error";
        }
        return "success";
    }

    @Override
    public String getSelectedTab() {
        return "create";
    }

    public String getPassword() {
        return this.password;
    }

    @StrutsParameter
    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    @StrutsParameter
    public void setEmail(String email) {
        this.email = email;
    }

    public boolean getSendEmail() {
        return this.sendEmail;
    }

    @StrutsParameter
    public void setSendEmail(boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    public String getFullName() {
        return this.fullName;
    }

    @StrutsParameter
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getConfirm() {
        return this.confirm;
    }

    @StrutsParameter
    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public Directory getDirectory() {
        if (this.directory == null && this.directoryId != 0L) {
            this.directory = this.crowdDirectoryService.findDirectoryById(this.directoryId);
        }
        return this.directory;
    }

    @StrutsParameter
    public void setDirectoryId(long directoryId) {
        this.directoryId = directoryId;
    }

    public void setUserFormValidator(UserFormValidator validator) {
        this.validator = validator;
    }

    public void setUserAccessor(UserAccessorInternal userAccessorInternal) {
        super.setUserAccessor(userAccessorInternal);
        this.userAccessorInternal = userAccessorInternal;
    }

    @Override
    public AdminAddedUserEvent getEventToPublish(String result) {
        if ("success".equals(result)) {
            return new AdminAddedUserEvent(this.newUser);
        }
        return null;
    }

    @Override
    public boolean isPermitted() {
        return this.permissionManager.isConfluenceAdministrator(this.getAuthenticatedUser()) || this.permissionManager.isSystemAdministrator(this.getAuthenticatedUser());
    }
}

