/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.ExternalUserManagementAware;
import com.atlassian.confluence.user.UserManagementOperationFailedException;
import com.atlassian.confluence.user.actions.AbstractUsersAction;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.EntityException;
import java.util.Arrays;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdminOnly
@ReadOnlyAccessAllowed
public class DeactivateUserAction
extends AbstractUsersAction
implements ExternalUserManagementAware {
    private static final Logger log = LoggerFactory.getLogger(DeactivateUserAction.class);
    private boolean isEnableDisableLocal;

    private void doDeactivateUser() throws EntityException, UserManagementOperationFailedException {
        if (this.isEnableDisableLocal) {
            this.userAccessor.deactivateUserLocally(this.getUser());
        } else {
            this.userAccessor.deactivateUser(this.getUser());
        }
    }

    private void doReactivateUser() throws EntityException, UserManagementOperationFailedException {
        if (this.isEnableDisableLocal) {
            this.userAccessor.reactivateUserLocally(this.getUser());
        } else {
            this.userAccessor.reactivateUser(this.getUser());
        }
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String doDeactivate() {
        try {
            this.doDeactivateUser();
        }
        catch (UserManagementOperationFailedException | EntityException e) {
            log.error("Failed to deactivate user {}", (Object)this.getUser(), e);
        }
        return this.userAccessor.isDeactivated(this.getUsername()) ? "success" : "error";
    }

    public String doReactivate() {
        try {
            this.doReactivateUser();
        }
        catch (UserManagementOperationFailedException | EntityException e) {
            log.error("Failed to reactivate user {}", (Object)this.getUser(), e);
        }
        return this.userAccessor.isDeactivated(this.getUsername()) ? "error" : "success";
    }

    public List<String> getUserDeactivationInformation() {
        return Arrays.asList(this.getText("user.deactivate.action.consequence.disable.ability.to.login"), this.getText("user.deactivate.action.consequence.user.nocontrib.to.license.count"));
    }

    public List<String> getUserReactivationInformation() {
        return Arrays.asList(this.getText("user.reactivate.action.consequence.enable.ability.to.login"), this.getText("user.reactivate.action.consequence.user.contrib.to.license.count"));
    }

    public boolean getIsEnableDisableLocal() {
        return this.isEnableDisableLocal;
    }

    @StrutsParameter
    public void setIsEnableDisableLocal(boolean isEnableDisableLocal) {
        this.isEnableDisableLocal = isEnableDisableLocal;
    }
}

