/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.core.FormAware;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.confluence.util.HTMLPairType;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.ArrayList;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class EditEmailSettingsAction
extends AbstractUserProfileAction
implements FormAware {
    private boolean notifyByEmail = false;
    private boolean isSiteBlogWatchForUser;
    private boolean isWatchingNetwork;
    private boolean notifyForMyOwnActions = false;
    private boolean watchMyOwnContent = false;
    private boolean showDiffInEmailNotifications = false;
    private boolean notifyOnNewFollowers;
    private String mimeType;
    private boolean isReceiveRecommendedEmail = false;

    public String execute() throws Exception {
        this.updateUser();
        return "success";
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doInput() throws Exception {
        return "input";
    }

    @StrutsParameter
    public void setShowDiffInEmailNotifications(boolean showDiffInEmailNotifications) {
        this.showDiffInEmailNotifications = showDiffInEmailNotifications;
    }

    @StrutsParameter
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @StrutsParameter
    public void setNotifyForMyOwnActions(boolean notifyForMyOwnActions) {
        this.notifyForMyOwnActions = notifyForMyOwnActions;
    }

    @StrutsParameter
    public void setWatchMyOwnContent(boolean watchMyOwnContent) {
        this.watchMyOwnContent = watchMyOwnContent;
    }

    @StrutsParameter
    public void setNotifyByEmail(boolean notifyByEmail) {
        this.notifyByEmail = notifyByEmail;
    }

    @StrutsParameter
    public void setSiteBlogWatchForUser(boolean siteBlogWatchForUser) {
        this.isSiteBlogWatchForUser = siteBlogWatchForUser;
    }

    private void updateUser() throws UserPreferences.PreferenceException {
        if (this.notifyByEmail) {
            this.notificationManager.addDailyReportNotification(this.getAuthenticatedUser());
        } else {
            this.notificationManager.removeDailyReportNotification(this.getAuthenticatedUser());
        }
        this.notificationManager.setSiteBlogNotificationForUser(this.getAuthenticatedUser(), this.isSiteBlogWatchForUser);
        this.notificationManager.setNetworkNotificationForUser(this.getAuthenticatedUser(), this.isWatchingNetwork);
        this.userPreferences().setBoolean("confluence.prefs.notify.for.my.own.actions", this.notifyForMyOwnActions);
        this.userPreferences().setBoolean("confluence.prefs.watch.my.own.content", this.watchMyOwnContent);
        this.userPreferences().setBoolean("confluence.prefs.email.show.diff", this.showDiffInEmailNotifications);
        this.userPreferences().setString("confluence.prefs.email.mimetype", this.getMimeType());
        this.userPreferences().setBoolean("confluence.prefs.notify.on.new.followers", this.notifyOnNewFollowers);
        this.userPreferences().setBoolean("confluence.prefs.daily.summary.receive.updates.set", true);
        this.userPreferences().setBoolean("confluence.prefs.daily.summary.receive.updates", this.isReceiveRecommendedEmail);
    }

    @Override
    public boolean isPermitted() {
        return this.getUsername() != null && super.isPermitted();
    }

    @Override
    public boolean isEditMode() {
        return true;
    }

    public String getMimeType() {
        if (this.mimeType == null && this.userPreferences() != null) {
            this.mimeType = this.userPreferences().getString("confluence.prefs.email.mimetype").orElse(null);
        }
        if (this.mimeType == null || this.mimeType.equals("html")) {
            this.mimeType = "text/html";
        }
        return this.mimeType;
    }

    public List<HTMLPairType> getMimeTypes() {
        ArrayList<HTMLPairType> mimeTypes = new ArrayList<HTMLPairType>();
        mimeTypes.add(new HTMLPairType(this.getText("mimetypes.HTML"), "text/html"));
        mimeTypes.add(new HTMLPairType(this.getText("mimetypes.Text"), "text/plain"));
        return mimeTypes;
    }

    public boolean isNotifyByEmail() {
        this.notifyByEmail = this.notificationManager.getDailyReportNotificationForUser(this.getAuthenticatedUser()) != null;
        return this.notifyByEmail;
    }

    public boolean isSiteBlogWatchForUser() {
        this.isSiteBlogWatchForUser = this.notificationManager.getSiteBlogNotificationForUser(this.getAuthenticatedUser()) != null;
        return this.isSiteBlogWatchForUser;
    }

    public boolean isWatchingNetwork() {
        this.isWatchingNetwork = this.notificationManager.getNetworkNotificationForUser(this.getAuthenticatedUser()) != null;
        return this.isWatchingNetwork;
    }

    @StrutsParameter
    public void setWatchingNetwork(boolean watchingNetwork) {
        this.isWatchingNetwork = watchingNetwork;
    }

    public boolean isNotifyForMyOwnActions() {
        return this.userPreferences().getBoolean("confluence.prefs.notify.for.my.own.actions").orElse(false);
    }

    public boolean isWatchMyOwnContent() {
        return this.userPreferences().getBoolean("confluence.prefs.watch.my.own.content").orElse(false);
    }

    public boolean isShowDiffInEmailNotifications() {
        return this.userPreferences().getBoolean("confluence.prefs.email.show.diff").orElse(false);
    }

    public boolean isNotifyOnNewFollowers() {
        return this.userPreferences().getBoolean("confluence.prefs.notify.on.new.followers").orElse(false);
    }

    @StrutsParameter
    public void setNotifyOnNewFollowers(boolean notifyOnNewFollowers) {
        this.notifyOnNewFollowers = notifyOnNewFollowers;
    }

    public boolean isReceiveRecommendedEmail() {
        return this.userPreferences().getBoolean("confluence.prefs.daily.summary.receive.updates").orElse(false);
    }

    @StrutsParameter
    public void setReceiveRecommendedEmail(boolean setIt) {
        this.isReceiveRecommendedEmail = setIt;
    }
}

