/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.core.FormAware;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.user.actions.ViewMySettingsAction;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class EditMySettingsAction
extends ViewMySettingsAction
implements FormAware {
    private boolean isUserLocaleUpdated;

    @Override
    public String doEdit() throws UserPreferences.PreferenceException {
        this.isUserLocaleUpdated = false;
        this.updateUserPreferences();
        boolean isSuccessful = this.getFieldErrors().isEmpty();
        if (this.isUserLocaleUpdated) {
            this.localeManager.invalidateLocaleInfoCache(this.getUser());
        }
        return isSuccessful ? "success" : "input";
    }

    @Override
    public void validate() {
        Language language;
        super.validate();
        if (StringUtils.isNotBlank((CharSequence)this.preferredUserLocale) && !this.preferredUserLocale.equals("None") && (language = this.languageManager.getLanguage(this.preferredUserLocale)) == null) {
            this.addActionError(this.getText("language.not.valid"));
        }
    }

    protected void updateUserPreferences() throws UserPreferences.PreferenceException {
        UserPreferences userPreferences = this.userPreferences();
        if ("".equals(this.siteHomePage)) {
            try {
                userPreferences.remove("confluence.user.site.homepage");
            }
            catch (UserPreferences.PreferenceException preferenceException) {}
        } else {
            userPreferences.setString("confluence.user.site.homepage", this.siteHomePage);
        }
        Optional<String> userLocale = userPreferences.getString("confluence.user.locale");
        if (this.preferredUserLocale.equals("None")) {
            if (userLocale.isPresent()) {
                userPreferences.remove("confluence.user.locale");
                this.isUserLocaleUpdated = true;
            }
        } else {
            userPreferences.setString("confluence.user.locale", this.preferredUserLocale.trim());
            this.isUserLocaleUpdated = true;
        }
        if (this.keyboardShortcutsEnabled == null) {
            this.keyboardShortcutsEnabled = false;
        }
        userPreferences.setBoolean("confluence.user.keyboard.shortcuts.disabled", this.keyboardShortcutsEnabled == false);
        if (this.highlightOptionPanelEnabled == null) {
            this.highlightOptionPanelEnabled = false;
        }
        userPreferences.setBoolean("confluence.user.highlight.option.panel.enabled", this.highlightOptionPanelEnabled);
        this.userAccessor.getUserPreferences(this.getUser()).setString("confluence.user.time.zone", this.getUserTimeZone());
    }

    @StrutsParameter
    public void setPreferredUserLocale(String locale) {
        this.preferredUserLocale = locale;
    }

    @StrutsParameter
    public void setKeyboardShortcutsEnabled(boolean keyboardShortcutsEnabled) {
        this.keyboardShortcutsEnabled = keyboardShortcutsEnabled;
    }

    @StrutsParameter
    public void setHighlightOptionPanelEnabled(boolean highlightOptionPanelEnabled) {
        this.highlightOptionPanelEnabled = highlightOptionPanelEnabled;
    }

    @StrutsParameter
    public void setSiteHomePage(String siteHomePage) {
        this.siteHomePage = siteHomePage;
    }

    @StrutsParameter
    public void setUserTimeZone(String timeZoneID) {
        this.userTimeZone = TimeZone.getInstance(timeZoneID);
    }

    @Override
    public boolean isPermitted() {
        return this.getUsername() != null && super.isPermitted();
    }

    @Override
    public boolean isEditMode() {
        return true;
    }
}

