/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.core.FormAware;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class EditorSettingsAction
extends AbstractUserProfileAction
implements FormAware {
    private boolean editMode = false;
    private boolean autocompleteDisabled = false;
    private boolean autoformatDisabled = false;

    @PermittedMethods(value={HttpMethod.GET})
    public String doView() throws Exception {
        return "success";
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doInput() throws Exception {
        this.editMode = true;
        return "input";
    }

    public String execute() throws Exception {
        this.updateUser();
        return "success";
    }

    private void updateUser() throws UserPreferences.PreferenceException {
        this.userPreferences().setBoolean("confluence.prefs.editor.disable.autocomplete", this.autocompleteDisabled);
        this.userPreferences().setBoolean("confluence.prefs.editor.disable.autoformat", this.autoformatDisabled);
    }

    public boolean isAutocompleteDisabled() {
        return this.userPreferences().getBoolean("confluence.prefs.editor.disable.autocomplete").orElse(false);
    }

    @StrutsParameter
    public void setAutocompleteDisabled(boolean autocompleteDisabled) {
        this.autocompleteDisabled = autocompleteDisabled;
    }

    public boolean isAutoformatDisabled() {
        return this.userPreferences().getBoolean("confluence.prefs.editor.disable.autoformat").orElse(false);
    }

    @StrutsParameter
    public void setAutoformatDisabled(boolean autoformatDisabled) {
        this.autoformatDisabled = autoformatDisabled;
    }

    @Override
    public boolean isPermitted() {
        return this.getUsername() != null && super.isPermitted();
    }

    @Override
    public boolean isEditMode() {
        return this.editMode;
    }
}

