/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.admin.criteria.MailServerExistsCriteria;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.security.ForgotPasswordEvent;
import com.atlassian.confluence.event.events.security.ForgotPasswordUnknownUserEvent;
import com.atlassian.confluence.impl.ratelimiter.ActionRateLimiter;
import com.atlassian.confluence.security.CaptchaAware;
import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.struts.soy.ActionViewData;
import com.atlassian.confluence.struts.soy.ActionViewDataMappings;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserVerificationTokenManager;
import com.atlassian.confluence.user.UserVerificationTokenType;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ForgotUserPasswordAction
extends ConfluenceActionSupport
implements CaptchaAware {
    private static final Logger log = LoggerFactory.getLogger(ForgotUserPasswordAction.class);
    private String usernameOrEmail;
    private MailServerManager mailServerManager;
    private String token;
    private UserVerificationTokenManager userVerificationTokenManager;
    private CaptchaManager captchaManager;
    private ActionRateLimiter actionRateLimiterForgetuserpassword;
    private XsrfTokenGenerator xsrfTokenGenerator;
    private MailServerExistsCriteria mailServerExistsCriteria;

    @ActionViewDataMappings
    public Map<String, Object> getForgotUserPasswordActionViewDataMappings() {
        return ImmutableMap.builder().put((Object)"xsrfTokenName", (Object)this.xsrfTokenGenerator.getXsrfTokenName()).put((Object)"xsrfTokenValue", (Object)this.xsrfTokenGenerator.generateToken(this.getActiveRequest())).put((Object)"token", (Object)(this.token == null ? "" : this.token)).put((Object)"generateCaptchaId", (Object)(this.getCaptchaManager() == null ? "" : this.getCaptchaManager().generateCaptchaId())).put((Object)"siteTitle", (Object)this.globalSettingsManager.getGlobalSettings().getSiteTitle()).put((Object)"mailServerConfigured", (Object)this.mailServerExistsCriteria.isMet()).put((Object)"getActionName", (Object)this.getActionName()).build();
    }

    @Override
    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doDefault() {
        return "input";
    }

    @Override
    public void validate() {
        super.validate();
        if (!this.isMailServerConfigured()) {
            this.addActionError("forgot.pass.nomailserver", this.getGlobalSettings().getSiteTitle());
        }
        if (StringUtils.isBlank((CharSequence)this.getUsernameOrEmail())) {
            this.addFieldError("usernameOrEmail", this.getText("error.username.or.email.required.field"));
        }
    }

    public String execute() throws Exception {
        String isReqAllowed = this.actionRateLimiterForgetuserpassword.isRequestAllowed(this.usernameOrEmail, "doforgotuserpassword");
        if (!isReqAllowed.equals("success")) {
            ServletActionContext.getResponse().setStatus(429);
            return isReqAllowed;
        }
        ConfluenceUser user = this.getUser();
        if (user == null) {
            ForgotPasswordUnknownUserEvent forgotPasswordUnknownUserEvent = new ForgotPasswordUnknownUserEvent(this, this.usernameOrEmail);
            this.eventPublisher.publish((Object)forgotPasswordUnknownUserEvent);
            return "success";
        }
        this.token = this.userVerificationTokenManager.generateAndSaveToken(user.getName(), UserVerificationTokenType.PASSWORD_RESET);
        ForgotPasswordEvent event = new ForgotPasswordEvent(user, this.getChangePasswordLink(), this.getChangePasswordRequestLink());
        this.eventPublisher.publish((Object)event);
        return "success";
    }

    @HtmlSafe
    public String getChangePasswordLink() {
        return this.getBaseUrl() + "resetuserpassword.action?username=" + HtmlUtil.urlEncode(this.getUser().getName()) + "&token=" + this.token;
    }

    public String getChangePasswordRequestLink() {
        return this.getBaseUrl() + "forgotuserpassword.action";
    }

    private String getBaseUrl() {
        Object baseUrl = this.getGlobalSettings().getBaseUrl();
        if (!((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        return baseUrl;
    }

    public ConfluenceUser getUser() {
        ConfluenceUser user = this.userAccessor.getUserByName(this.usernameOrEmail);
        if (user == null) {
            try {
                List<User> users = this.userAccessor.findUsersAsList((Query<User>)new EmailTermQuery(this.usernameOrEmail));
                if (users != null && !users.isEmpty()) {
                    user = this.getUserByName(users.get(0).getName());
                }
            }
            catch (EntityException e) {
                log.error("Unable to find users", (Throwable)e);
            }
        }
        return user;
    }

    public String format(String format, Object ... args) {
        return String.format(format, args);
    }

    public boolean isMailServerConfigured() {
        return this.mailServerManager.isDefaultSMTPMailServerDefined();
    }

    @Override
    public boolean isPermitted() {
        return true;
    }

    @ActionViewData
    public String getUsernameOrEmail() {
        return this.usernameOrEmail;
    }

    @StrutsParameter
    public void setUsernameOrEmail(String usernameOrEmail) {
        this.usernameOrEmail = usernameOrEmail;
    }

    public void setMailServerManager(MailServerManager mailServerManager) {
        this.mailServerManager = mailServerManager;
    }

    public void setUserVerificationTokenManager(UserVerificationTokenManager userVerificationTokenManager) {
        this.userVerificationTokenManager = userVerificationTokenManager;
    }

    public CaptchaManager getCaptchaManager() {
        return this.captchaManager;
    }

    public void setCaptchaManager(CaptchaManager captchaManager) {
        this.captchaManager = captchaManager;
    }

    @Override
    public boolean mustValidateCaptcha() {
        return true;
    }

    public void setActionRateLimiterForgetuserpassword(ActionRateLimiter actionRateLimiterForgetuserpassword) {
        this.actionRateLimiterForgetuserpassword = actionRateLimiterForgetuserpassword;
    }

    public void setXsrfTokenGenerator(XsrfTokenGenerator xsrfTokenGenerator) {
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    public void setMailServerExistsCriteria(MailServerExistsCriteria mailServerExistsCriteria) {
        this.mailServerExistsCriteria = mailServerExistsCriteria;
    }
}

