/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.struts.soy.ActionViewDataMappings;
import com.atlassian.confluence.user.actions.AbstractLoginSignupAction;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.seraph.auth.AuthenticationErrorType;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.filter.LoginFilterRequest;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.struts2.ActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@UnrestrictedAccess
public class LoginAction
extends AbstractLoginSignupAction {
    private static final UrlValidator urlValidator = new UrlValidator(new String[]{"http", "https"}, 8L);
    private HttpContext httpContext;
    private String os_username;

    @ActionViewDataMappings
    public Map<String, Object> getLoginActionViewDataMappings() {
        return ImmutableMap.builder().putAll(this.commonActionViewDataMappings()).put((Object)"os_username", (Object)StringUtils.defaultString((String)this.getOs_username())).put((Object)"isElevatedSecurityCheckRequired", (Object)this.isElevatedSecurityCheckRequired()).put((Object)"isShowForgottenPasswordHelp", this.upgradeManager == null ? "" : Boolean.valueOf(this.isShowForgottenPasswordHelp())).put((Object)"logout", (Object)this.isLogout()).build();
    }

    @Override
    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    @XsrfProtectionExcluded
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    public void validate() {
        HttpServletRequest req = this.httpContext.getActiveRequest();
        if (req.getRemoteUser() != null) {
            String originalURL = SeraphUtils.getOriginalURL(req);
            if (originalURL != null) {
                if (this.isValidUrl(originalURL)) {
                    this.addActionError("login.not.permitted.description", originalURL);
                } else {
                    this.addActionError(this.getText("login.not.permitted.no-url-description"));
                }
            }
            return;
        }
        if (this.isElevatedSecurityCheckRequired()) {
            this.addActionError(this.getText("login.elevatedsecuritycheck.required"));
            if (null != req.getAttribute("ElevatedSecurityGuard_Failure")) {
                this.addFieldError("captcha", this.getText("login.elevatedsecuritycheck.required.captcharesponse.invalid"));
            }
            return;
        }
        String authStatus = LoginFilterRequest.getAuthenticationStatus((HttpServletRequest)req);
        if ("failed".equals(authStatus)) {
            this.addActionError(this.getText("wrong.password"));
        } else if ("error".equals(authStatus)) {
            AuthenticationErrorType errorType = LoginFilterRequest.getAuthenticationErrorType((HttpServletRequest)req);
            if (errorType == AuthenticationErrorType.CommunicationError) {
                this.addActionError(this.getText("comms.error.occurred"));
            } else {
                this.addActionError(this.getText("error.occurred"));
            }
        }
    }

    private boolean isValidUrl(String originalURL) {
        if (urlValidator.isValid(originalURL)) {
            return true;
        }
        String baseUrl = this.getGlobalSettings().getBaseUrl();
        return urlValidator.isValid(baseUrl + originalURL);
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    @XsrfProtectionExcluded
    public String execute() throws Exception {
        String refererURL;
        if (StringUtils.isBlank((CharSequence)this.os_destination) && StringUtils.isNotBlank((CharSequence)(refererURL = this.getRefererURL()))) {
            ActionContext.getContext().getSession().put(SecurityConfigFactory.getInstance().getOriginalURLKey(), refererURL);
        }
        return "success";
    }

    private String getRefererURL() {
        HttpServletRequest request = this.getActiveRequest();
        String referer = request.getHeader("Referer");
        if (StringUtils.isBlank((CharSequence)referer)) {
            return null;
        }
        if (referer.contains("logout") || referer.contains("login")) {
            return null;
        }
        Object result = null;
        String baseUrl = this.getGlobalSettings().getBaseUrl();
        if (referer.startsWith(baseUrl) && !((String)(result = referer.substring(baseUrl.length()))).startsWith("/")) {
            result = "/" + (String)result;
        }
        return result;
    }

    @Override
    public boolean isPermitted() {
        return true;
    }

    public String getOs_username() {
        return this.os_username;
    }

    @StrutsParameter
    public void setOs_username(String os_username) {
        this.os_username = os_username;
    }

    public boolean isShowForgottenPasswordHelp() {
        return this.loginPageFunctionalityService.showForgottenPasswordHelp();
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public boolean isElevatedSecurityCheckRequired() {
        return this.loginManager.requiresElevatedSecurityCheck(this.os_username);
    }
}

