/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.actions.AuthenticationHelper;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.security.Principal;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
public class LogoutAction
extends ConfluenceActionSupport {
    private static final String DEFAULT_LOGOUT_URL = "/login.action?logout=true";
    private String logoutUrl;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        Principal user = authenticator.getUser(this.getActiveRequest());
        boolean isLoggedOut = AuthenticationHelper.userLogout(user, this.getActiveRequest(), this.getActiveResponse(), this.eventPublisher, this);
        if (!isLoggedOut) {
            this.addActionError("unsuccessful.logout.message");
            return "error";
        }
        this.logoutUrl = this.getRedirectLogoutURL();
        return "success";
    }

    @Override
    public boolean isPermitted() {
        return true;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    private String getRedirectLogoutURL() {
        String logoutUrl = SecurityConfigFactory.getInstance().getLogoutURL();
        return StringUtils.isBlank((CharSequence)logoutUrl) ? DEFAULT_LOGOUT_URL : logoutUrl;
    }
}

