/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.longtasks.LongTaskSubmission;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.dmz.user.UserAccessorInternal;
import com.atlassian.confluence.event.events.analytics.UserRemoveInitiatedAnalyticsEvent;
import com.atlassian.confluence.security.ExternalUserManagementAware;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.AbstractUsersAction;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdminOnly
@ReadOnlyAccessAllowed
public class RemoveUnsyncedUserAction
extends AbstractUsersAction
implements ExternalUserManagementAware {
    private SpaceManager spaceManager;
    private String taskId;
    private static final Logger logger = LoggerFactory.getLogger(RemoveUnsyncedUserAction.class);

    @Override
    public String doDefault() throws Exception {
        this.eventPublisher.publish((Object)new UserRemoveInitiatedAnalyticsEvent(true));
        return super.doDefault();
    }

    @Override
    public void validate() {
        if (this.getUser() == null) {
            this.addActionError(this.getText("user.doesnt.exist"));
        } else if (this.isDeletedUser()) {
            this.addActionError(this.getText("user.already.deleted"));
        } else if (!this.isUnsyncedUser()) {
            this.addActionError(this.getText("user.not.unsynced"));
        }
        super.validate();
    }

    private boolean isUnsyncedUser() {
        return ((UserAccessorInternal)this.userAccessor).isUnsyncedUser(this.getUser());
    }

    private boolean isDeletedUser() {
        return ((UserAccessorInternal)this.userAccessor).isDeletedUser(this.getUser());
    }

    @Override
    public ConfluenceUser getUser() {
        if (this.user == null) {
            this.user = this.userAccessor.getUserByKey(this.userKey);
        }
        return this.user;
    }

    public String execute() throws Exception {
        try {
            Person person = (Person)this.personService.find(new Expansion[0]).withUserKey(this.getUserKey()).fetchOrNull();
            LongTaskSubmission longTaskSubmission = this.personService.delete(person);
            this.taskId = longTaskSubmission.getId().serialise();
            return "success";
        }
        catch (ServiceException e) {
            logger.error("Failed to remove unsynced user with key {}", (Object)this.userKey, (Object)e);
            this.addActionError("remove.failed", this.getUser() != null ? this.getUser().getName() : null);
            return "error";
        }
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public boolean hasPersonalSpace() {
        return this.spaceManager.getPersonalSpace(this.getUser()) != null;
    }

    public @Nullable String getPersonalSpaceKey() {
        Space personalSpace = this.spaceManager.getPersonalSpace(this.getUser());
        return personalSpace == null ? null : personalSpace.getKey();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public List<String> getUserContentCleanupInformation() {
        return Arrays.asList(this.getText("user.delete.consequence.remove.details"), this.getText("user.delete.consequence.replace.username.with.alias"));
    }
}

