/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.CaptchaAware;
import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.confluence.struts.soy.ActionViewData;
import com.atlassian.confluence.struts.soy.ActionViewDataMappings;
import com.atlassian.confluence.user.UserVerificationTokenManager;
import com.atlassian.confluence.user.UserVerificationTokenType;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import com.atlassian.user.EntityException;
import com.atlassian.user.security.authentication.InvalidPasswordException;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@UnrestrictedAccess
public class ResetUserPasswordAction
extends ConfluenceActionSupport
implements CaptchaAware {
    private String username;
    private String token;
    private String newPassword;
    private String newPasswordConfirmation;
    private UserVerificationTokenManager userVerificationTokenManager;
    private CaptchaManager captchaManager;
    private XsrfTokenGenerator xsrfTokenGenerator;

    @ActionViewDataMappings
    public Map<String, Object> getResetUserPasswordActionViewDataMappings() {
        return ImmutableMap.builder().put((Object)"xsrfTokenName", (Object)this.xsrfTokenGenerator.getXsrfTokenName()).put((Object)"xsrfTokenValue", (Object)this.xsrfTokenGenerator.generateToken(this.getActiveRequest())).put((Object)"getActionName", (Object)this.getActionName()).put((Object)"username", (Object)this.getUsername()).put((Object)"token", (Object)(this.token == null ? "" : this.token)).put((Object)"generateCaptchaId", (Object)(this.getCaptchaManager() == null ? "" : this.getCaptchaManager().generateCaptchaId())).build();
    }

    @Override
    @PermittedMethods(value={HttpMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    public void validate() {
        if (this.getUserByName(this.username) == null) {
            this.addActionError(this.getText("reset.password.error", new String[]{PlainTextToHtmlConverter.encodeHtmlEntities(this.username)}));
        } else if (!this.userVerificationTokenManager.hasValidUserToken(this.username, UserVerificationTokenType.PASSWORD_RESET, this.token) && !this.userVerificationTokenManager.hasValidUserToken(this.username, UserVerificationTokenType.USER_SIGNUP, this.token)) {
            this.addActionError(this.getText("reset.password.error"));
        }
        super.validate();
    }

    public String doResetPassword() {
        if (this.newPassword == null || !this.newPassword.equals(this.newPasswordConfirmation)) {
            this.addFieldError("newPasswordConfirmation", this.getText("your.pass.confirmpass.dont.match"));
            return "input";
        }
        try {
            this.userAccessor.alterPassword(this.getUserByName(this.username), this.newPassword, this.token);
            this.userVerificationTokenManager.clearToken(this.username);
        }
        catch (InvalidPasswordException e) {
            this.addFieldError("newPassword", this.getText("new.pass.invalid"));
            return "input";
        }
        catch (EntityException e) {
            this.addFieldError("newPassword", this.getText("new.pass.error"));
            return "input";
        }
        return "success";
    }

    @Override
    public boolean isPermitted() {
        return true;
    }

    @StrutsParameter
    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    @ActionViewData
    public String getEncodedUserName() {
        return HtmlUtil.urlEncode(this.username, StandardCharsets.UTF_8);
    }

    @StrutsParameter
    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    @StrutsParameter
    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    @StrutsParameter
    public void setNewPasswordConfirmation(String newPasswordConfirmation) {
        this.newPasswordConfirmation = newPasswordConfirmation;
    }

    public void setUserVerificationTokenManager(UserVerificationTokenManager userVerificationTokenManager) {
        this.userVerificationTokenManager = userVerificationTokenManager;
    }

    public CaptchaManager getCaptchaManager() {
        return this.captchaManager;
    }

    public void setCaptchaManager(CaptchaManager captchaManager) {
        this.captchaManager = captchaManager;
    }

    @Override
    public boolean mustValidateCaptcha() {
        return true;
    }

    public void setXsrfTokenGenerator(XsrfTokenGenerator xsrfTokenGenerator) {
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }
}

