/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.dmz.BandanaManagerInternal;
import com.atlassian.confluence.admin.criteria.MailServerExistsCriteria;
import com.atlassian.confluence.admin.criteria.WritableDirectoryExistsCriteria;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.event.events.admin.SearchUsersEvent;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.AbstractSearchCrowdUsersAction;
import com.atlassian.confluence.util.SearchTermType;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.BreadcrumbAware;
import com.atlassian.confluence.util.breadcrumbs.UserAdminActionBreadcrumb;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@AdminOnly
public class SearchUsersAction
extends AbstractSearchCrowdUsersAction
implements BreadcrumbAware {
    protected CrowdDirectoryService crowdDirectoryService;
    private BandanaManagerInternal bandanaManager;
    private MailServerExistsCriteria mailServerExistsCriteria;
    private WritableDirectoryExistsCriteria writableDirectoryExistsCriteria;

    public SearchUsersAction() {
        this.setPageResponse((PageResponse<ConfluenceUser>)PageResponseImpl.empty((boolean)false));
        this.setShowUnlicensedUsers(true);
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        return "success";
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String doCreateUserForm() {
        this.setSelectedTab("create");
        return "input";
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String doInviteUserForm() {
        this.setSelectedTab("invite");
        return "input";
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String doSignUpUserForm() {
        this.setSelectedTab("signup");
        return "input";
    }

    public boolean isSendEmailDefault() {
        Boolean sendEmail = (Boolean)this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "sendEmail");
        return sendEmail == null || sendEmail != false;
    }

    protected void setSendEmailDefault(boolean sendEmail) {
        this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, "sendEmail", (Object)sendEmail);
    }

    public boolean isMailServerConfigured() {
        return this.mailServerExistsCriteria.isMet();
    }

    public boolean canAddUsers() {
        return this.permissionManager.isConfluenceAdministrator(this.getAuthenticatedUser()) && this.writableDirectoryExistsCriteria.isMet();
    }

    public List<Directory> getActiveDirectories() {
        return this.crowdDirectoryService.findAllDirectories().stream().filter(Directory::isActive).toList();
    }

    public List<Map<String, String>> getActiveDirectoriesOptions() {
        return Stream.concat(Stream.of(Map.of("text", "", "value", "-1")), this.getActiveDirectories().stream().map(directory -> Map.of("text", directory.getName(), "value", String.valueOf(directory.getId())))).toList();
    }

    public void setCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @Override
    public boolean isPermitted() {
        return this.permissionManager.isConfluenceAdministrator(this.getAuthenticatedUser()) || this.permissionManager.isSystemAdministrator(this.getAuthenticatedUser());
    }

    public void setMailServerExistsCriteria(MailServerExistsCriteria mailServerExistsCriteria) {
        this.mailServerExistsCriteria = mailServerExistsCriteria;
    }

    public void setWritableDirectoryExistsCriteria(WritableDirectoryExistsCriteria writableDirectoryExistsCriteria) {
        this.writableDirectoryExistsCriteria = writableDirectoryExistsCriteria;
    }

    public void setBandanaManager(BandanaManagerInternal bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @Override
    public Breadcrumb getBreadcrumb() {
        return new UserAdminActionBreadcrumb(this, null);
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public LoginInfo getLoginInfo(String userName) {
        return this.loginManager.getLoginInfo(this.getUserByName(userName));
    }

    private SearchTermType getSearchTermType(String searchTerm) {
        if (searchTerm == null) {
            return SearchTermType.ADVANCED;
        }
        if ("*".equals(searchTerm)) {
            return SearchTermType.ALL;
        }
        return SearchTermType.FILTERED;
    }

    public void publishEvent() {
        this.eventPublisher.publish((Object)new SearchUsersEvent(!this.isShowUnlicensedUsers(), this.getSearchTermType(this.getSearchTerm())));
    }

    @Override
    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    @XsrfProtectionExcluded
    public String doUserSearch() {
        this.publishEvent();
        return super.doUserSearch();
    }
}

