/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.ExternalUserManagementAware;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.actions.AbstractUsersAction;
import com.atlassian.confluence.util.PasswordPolicyErrorMessageHelper;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.security.authentication.InvalidPasswordException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdminOnly
@ReadOnlyAccessAllowed
public class SetUserPasswordAction
extends AbstractUsersAction
implements ExternalUserManagementAware {
    private static final Logger log = LoggerFactory.getLogger(SetUserPasswordAction.class);
    private String newPassword;
    private String newPasswordConfirmation;

    public String getNewPassword() {
        return this.newPassword;
    }

    @StrutsParameter
    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getNewPasswordConfirmation() {
        return this.newPasswordConfirmation;
    }

    @StrutsParameter
    public void setNewPasswordConfirmation(String newPasswordConfirmation) {
        this.newPasswordConfirmation = newPasswordConfirmation;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        return "success";
    }

    public void validateDoSet() {
        if (this.hasFieldErrors()) {
            return;
        }
        if (this.newPassword == null || !this.newPassword.equals(this.newPasswordConfirmation)) {
            this.addActionError(this.getText("user.pass.confirmpass.dont.match"));
        }
    }

    public String doSet() throws Exception {
        try {
            this.userAccessor.alterPassword(this.getUser(), this.newPassword);
        }
        catch (CrowdRuntimeException | InvalidPasswordException e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (PasswordPolicyErrorMessageHelper.isRootCauseInvalidCredentialExceptionDueToPasswordPolicy(rootCause)) {
                this.addActionError(PasswordPolicyErrorMessageHelper.getPasswordPolicyErrorMessage((Exception)e));
            } else {
                this.addActionError(this.getText("set.user.pass.failure"));
            }
            log.warn("Failed to update user password. Cause: {}", (Object)ExceptionUtils.getMessage((Throwable)rootCause));
            return "error";
        }
        return "success";
    }

    @Override
    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.EDIT, this.getUser());
    }
}

