/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.internal.user.GroupSearchRequest;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.AbstractSearchCrowdUsersAction;
import com.atlassian.confluence.validation.XWorkValidationResultSupport;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import io.atlassian.fugue.Pair;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class UserPickerAction
extends AbstractSearchCrowdUsersAction {
    private String onPopupSubmit;
    private boolean userSearch = true;
    private String groupTerm;
    private String memberGroups;

    @Override
    public void validate() {
        if (this.userSearch) {
            super.validate();
        }
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        if (this.userSearch) {
            return this.doUserSearch();
        }
        return this.doMemberOfGroupsSearch();
    }

    private String doMemberOfGroupsSearch() {
        GroupSearchRequest searchRequest = (GroupSearchRequest)GroupSearchRequest.builder().groupTerm(this.groupTerm).showUnlicensedUsers(this.isShowUnlicensedUsers()).build();
        try {
            Pair<List<String>, PageResponse<ConfluenceUser>> result = this.getUserSearchService().doMemberOfGroupsSearch(this.getPageRequest(), searchRequest);
            List groups = (List)result.left();
            this.setMemberGroups(StringUtils.join((Iterable)groups, (String)", "));
            this.setPageResponse((PageResponse<ConfluenceUser>)((PageResponse)result.right()));
            return "success";
        }
        catch (ServiceException e) {
            XWorkValidationResultSupport.addAnyMessages(this.getMessageHolder(), e);
            return "error";
        }
    }

    public String getGroupTerm() {
        return this.groupTerm;
    }

    @StrutsParameter
    public void setGroupTerm(String groupTerm) {
        this.groupTerm = groupTerm;
    }

    public String getOnPopupSubmit() {
        return this.onPopupSubmit;
    }

    @StrutsParameter
    public void setOnPopupSubmit(String onPopupSubmit) {
        this.onPopupSubmit = onPopupSubmit;
    }

    public boolean isUserSearch() {
        return this.userSearch;
    }

    @StrutsParameter
    public void setUserSearch(boolean userSearch) {
        this.userSearch = userSearch;
    }

    public String getMemberGroups() {
        return this.memberGroups;
    }

    @StrutsParameter
    public void setMemberGroups(String memberGroups) {
        this.memberGroups = memberGroups;
    }
}

