/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.follow.FollowManager;
import com.atlassian.confluence.impl.user.crowd.serviceaccount.ServiceAccountUserImpl;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UnknownUser;
import com.atlassian.confluence.user.actions.UserAware;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.User;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@UnrestrictedAccess
public class UserPopupAction
extends ConfluenceActionSupport
implements UserAware {
    private FollowManager followManager;
    private String username;
    private User user;
    private boolean canFollowUser;
    private String profileGroups;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        User user = this.getUser();
        this.canFollowUser = this.canFollow(user);
        return user == null ? "error" : "success";
    }

    private boolean canFollow(User followee) {
        return this.currentUserCanFollowOthers() && this.targetUserCanBeFollowed(followee);
    }

    private boolean currentUserCanFollowOthers() {
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        return currentUser != null && this.confluenceAccessManager.getUserAccessStatus(currentUser).hasLicensedAccess();
    }

    private boolean targetUserCanBeFollowed(User followee) {
        return followee != null && this.confluenceAccessManager.getUserAccessStatus(followee).hasLicensedAccess() && !(followee instanceof ServiceAccountUserImpl);
    }

    public String getUsername() {
        return this.username;
    }

    @StrutsParameter
    public void setUsername(String username) {
        this.username = username;
    }

    @StrutsParameter
    public void setProfileGroups(String profileGroups) {
        if (profileGroups != null) {
            this.profileGroups = profileGroups.trim();
        }
    }

    @Override
    public User getUser() {
        if (this.user == null) {
            this.user = this.userAccessor.getUserByName(this.username);
        }
        if (this.user == null && this.username != null) {
            this.user = UnknownUser.unknownUser(this.username, this.i18NBeanFactory.getI18NBean());
        }
        return this.user;
    }

    public boolean isFollowing() {
        User user = this.getUser();
        if (user == null || user instanceof ServiceAccountUserImpl) {
            return false;
        }
        return this.followManager.isUserFollowing(this.getAuthenticatedUser(), this.getUser());
    }

    @Override
    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.VIEW, this.getUser());
    }

    public void setFollowManager(FollowManager followManager) {
        this.followManager = followManager;
    }

    @Override
    public boolean isUserRequired() {
        return true;
    }

    @Override
    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean canFollowUser() {
        return this.canFollowUser;
    }

    public String getProfileGroups() {
        return this.profileGroups;
    }
}

