/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.confluence.core.FormAware;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.confluence.util.HTMLPairType;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewMyEmailSettingsAction
extends AbstractUserProfileAction
implements FormAware {
    private static final Logger log = LoggerFactory.getLogger(ViewMyEmailSettingsAction.class);
    private boolean editMode;
    private String mimeType;
    private String undoSetting;
    private String undoPreviousValue;
    private String undoMsgValue;
    private Map<String, String> undoActionMap = ImmutableMap.builder().put((Object)"subscribe-to-recommended", (Object)"/plugins/dailysummary/settings.action?setting=subscribe-to-recommended").put((Object)"switch-schedule", (Object)"/plugins/dailysummary/settings.action?setting=switch-schedule").build();
    private Map<String, String> undoMessageMap = ImmutableMap.builder().put((Object)"subscribe-to-recommended", (Object)"daily.summary.setting.undo.subscribe.message").put((Object)"switch-schedule", (Object)"daily.summary.setting.undo.schedulechange.message").build();
    public static final String RECOMMENDED_UPDATES_DEFAULT_ENABLED_KEY = "atl.confluence.plugins.confluence-daily-summary-email:admin.defaultEnabled";
    private PluginSettings globalSettings;

    @PermittedMethods(value={HttpMethod.GET})
    public String doView() throws Exception {
        this.editMode = false;
        return "success";
    }

    public String doEdit() throws Exception {
        this.editMode = true;
        return "input";
    }

    public boolean isNotifyForMyOwnActions() {
        return this.userPreferences().getBoolean("confluence.prefs.notify.for.my.own.actions").orElse(false);
    }

    public boolean isWatchMyOwnContent() {
        return this.userPreferences().getBoolean("confluence.prefs.watch.my.own.content").orElse(false);
    }

    public boolean isShowDiffInEmailNotifications() {
        return this.userPreferences().getBoolean("confluence.prefs.email.show.diff").orElse(false);
    }

    public boolean isNotifyByEmail() {
        if (this.getAuthenticatedUser() != null) {
            return this.notificationManager.getDailyReportNotificationForUser(this.getAuthenticatedUser()) != null;
        }
        return false;
    }

    public boolean isSiteBlogWatchForUser() {
        if (this.getAuthenticatedUser() != null) {
            return this.notificationManager.getSiteBlogNotificationForUser(this.getAuthenticatedUser()) != null;
        }
        return false;
    }

    public boolean isWatchingNetwork() {
        if (this.getAuthenticatedUser() != null) {
            return this.notificationManager.getNetworkNotificationForUser(this.getAuthenticatedUser()) != null;
        }
        return false;
    }

    public boolean isNotifyOnNewFollowers() {
        return this.userPreferences().getBoolean("confluence.prefs.notify.on.new.followers").orElse(false);
    }

    public boolean isReceiveRecommendedEmail() {
        UserPreferences userPrefs = this.userPreferences();
        Boolean isUserPrefExists = userPrefs.getBoolean("confluence.prefs.daily.summary.receive.updates.set").orElse(false);
        if (isUserPrefExists.booleanValue()) {
            return userPrefs.getBoolean("confluence.prefs.daily.summary.receive.updates").orElse(false);
        }
        String strVal = (String)this.globalSettings.get(RECOMMENDED_UPDATES_DEFAULT_ENABLED_KEY);
        return strVal == null || Boolean.parseBoolean(strVal);
    }

    public String getMimeType() {
        this.mimeType = this.userPreferences().getString("confluence.prefs.email.mimetype").orElse(null);
        if (this.mimeType == null || this.mimeType.equals("html")) {
            this.mimeType = "text/html";
        }
        return this.mimeType;
    }

    public String getMimeTypeUserFriendly() {
        try {
            if (this.getMimeType() == null || this.getMimeType().equals("text/html")) {
                return this.getText("mimetypes.HTML");
            }
            return this.getText("mimetypes.Text");
        }
        catch (RuntimeException e) {
            log.error("Unable to look up user's preferred mime type. User = {}, {}", new Object[]{this.getUser(), e, e});
            throw e;
        }
    }

    @StrutsParameter
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public List<HTMLPairType> getMimeTypes() {
        ArrayList<HTMLPairType> mimeTypes = new ArrayList<HTMLPairType>();
        mimeTypes.add(new HTMLPairType(this.getText("mimetypes.HTML"), "text/html"));
        mimeTypes.add(new HTMLPairType(this.getText("mimetypes.Text"), "text/plain"));
        return mimeTypes;
    }

    @Override
    public boolean isEditMode() {
        return this.editMode;
    }

    public boolean isUndoSettingsNeeded() {
        return !StringUtils.isBlank((CharSequence)this.undoSetting) && !StringUtils.isBlank((CharSequence)this.getUndoPreviousValue()) && this.getActionForUndoSetting() != null;
    }

    @StrutsParameter
    public void setUndoSetting(String setting) {
        this.undoSetting = setting;
    }

    public String getUndoSetting() {
        return this.undoSetting;
    }

    public String getUndoPreviousValue() {
        return this.undoPreviousValue;
    }

    @StrutsParameter
    public void setUndoPreviousValue(String previousValue) {
        this.undoPreviousValue = previousValue;
    }

    @StrutsParameter
    public void setUndoMsgValue(String value) {
        this.undoMsgValue = value;
    }

    public String getUndoMsgValue() {
        return this.undoMsgValue;
    }

    public String getActionForUndoSetting() {
        return this.undoActionMap.get(this.getUndoSetting());
    }

    public String getUndoConfirmationLabel() {
        String i18nPrevValue = this.getI18n().getText(this.undoMessageMap.get(this.undoSetting) + "." + this.getUndoMsgValue());
        if (i18nPrevValue == null) {
            i18nPrevValue = this.undoMsgValue;
        }
        return this.getI18n().getText(this.undoMessageMap.get(this.undoSetting), new Object[]{HtmlUtil.htmlEncode(i18nPrevValue)});
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
    }
}

