/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.struts.flash.FlashScope;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.AbstractUsersAction;
import com.atlassian.confluence.user.crowd.CrowdUserDirectoryHelper;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.EntityException;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AdminOnly
public class ViewUserAction
extends AbstractUsersAction {
    private static final Logger log = LoggerFactory.getLogger(ViewUserAction.class);
    private CrowdUserDirectoryHelper crowdUserDirectoryHelper;
    private CrowdService crowdService;
    private DirectoryManager directoryManager;
    private LoginInfo loginInfo;
    private User crowdUser;
    private List<Directory> directories;
    private boolean disableFailure;
    private boolean enableFailure;

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public void setCrowdUserDirectoryHelper(CrowdUserDirectoryHelper crowdUserDirectoryHelper) {
        this.crowdUserDirectoryHelper = crowdUserDirectoryHelper;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        Message message = (Message)FlashScope.get("user.created.message");
        if (message != null) {
            this.addActionMessage(message.getKey(), message.getArguments());
        }
        if (this.disableFailure) {
            this.addActionError("user.not.disabled", PlainTextToHtmlConverter.encodeHtmlEntities(this.getUsername()));
        }
        if (this.enableFailure) {
            this.addActionError("user.not.enabled", PlainTextToHtmlConverter.encodeHtmlEntities(this.getUsername()));
        }
        ConfluenceUser user = this.getUser();
        this.loginInfo = this.loginManager.getLoginInfo(user);
        this.crowdUser = this.crowdService.getUser(user != null ? user.getName() : "");
        this.directories = this.crowdUserDirectoryHelper.getDirectoriesForUser(user);
        return "success";
    }

    public boolean isUserDeactivated() {
        return this.userAccessor.isDeactivated(this.getUser());
    }

    public User getCrowdUser() {
        return this.crowdUser;
    }

    public List<Directory> getDirectories() {
        if (this.directories == null) {
            this.directories = this.crowdUserDirectoryHelper.getDirectoriesForUser(this.getUser());
        }
        return this.directories;
    }

    @Deprecated
    public Directory getDirectory() {
        if (this.getDirectories().isEmpty()) {
            return null;
        }
        return this.getDirectories().get(0);
    }

    public boolean canRemove() {
        ConfluenceUser user = this.getUser();
        try {
            return user != null && !user.getName().equals(this.getRemoteUsername()) && !this.getGlobalSettings().isExternalUserManagement() && this.userAccessor.isUserRemovable(user) && this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.REMOVE, user);
        }
        catch (EntityException e) {
            log.error("Error checking whether or not user is removable", (Throwable)e);
            this.addActionError("user.not.removable.check.failed", this.getUsername());
            return false;
        }
    }

    public boolean canEdit() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.EDIT, this.getUser());
    }

    public LoginInfo getLoginInfo() {
        return this.loginInfo;
    }

    @StrutsParameter
    public void setDisableFailure(boolean disableFailure) {
        this.disableFailure = disableFailure;
    }

    @StrutsParameter
    public void setEnableFailure(boolean enableFailure) {
        this.enableFailure = enableFailure;
    }

    public boolean isEditMode() {
        return false;
    }

    public boolean isUserRemoteAndLocallyManaged(ConfluenceUser user) {
        User remoteUser = this.crowdService.getRemoteUser(user.getName());
        return remoteUser != null && this.crowdUserDirectoryHelper.isInternalUserStatusSupported(remoteUser.getDirectoryId());
    }
}

