/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.FormAware;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.confluence.user.actions.UserAware;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.SpaceComparator;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class ViewUserProfileAction
extends AbstractUserProfileAction
implements FormAware,
UserAware {
    private static final Logger log = LoggerFactory.getLogger(ViewUserProfileAction.class);
    private PageManager pageManager;
    private ContentEntityManager contentEntityManager;
    private String username;
    private List recentlyUpdatedContent;
    private List favouriteSpaces;
    private static final int MAX_RECENTLY_UPDATED_CONTENT = 20;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        if (this.getUser() == null) {
            return "pagenotfound";
        }
        if (this.getPersonalInformationEntity() != null) {
            this.addToHistory(this.getPersonalInformationEntity());
        }
        return "success";
    }

    public String getPathToProfilePicture() {
        String filename = this.userPreferences().getString("confluence.user.profile.picture").orElse(null);
        if (this.getPersonalInformationEntity() != null) {
            for (Attachment attachment : this.getPersonalInformationEntity().getAttachments()) {
                if (!attachment.getFileName().equals(filename)) continue;
                return attachment.getDownloadPath();
            }
        }
        return null;
    }

    public List<String> getUserDetailsKeys(String groupKey) {
        return this.userDetailsManager.getProfileKeys(groupKey);
    }

    public List<String> getUserDetailsGroups() {
        return this.userDetailsManager.getProfileGroups();
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    @Override
    public String getUsername() {
        if (StringUtils.isEmpty((CharSequence)this.username) && this.getAuthenticatedUser() != null) {
            this.username = this.getAuthenticatedUser().getName();
        }
        return this.username;
    }

    @StrutsParameter
    public void setUsername(String username) {
        if (HtmlUtil.shouldUrlDecode(username)) {
            username = HtmlUtil.urlDecode(username);
        }
        this.username = username;
    }

    @Deprecated(forRemoval=true, since="9.3")
    public Date getSignupDate() {
        return null;
    }

    public Date getLastLoginDate() {
        return this.getPreviousLoginDate();
    }

    public int getAuthoredPagesCount() {
        return this.pageManager.getAuthoredPagesCountByUser(FindUserHelper.getUserByUsername(this.username));
    }

    public List getRecentlyUpdatedContent() {
        if (this.recentlyUpdatedContent == null) {
            ArrayList<PermissionManager.Criterion> criteria = new ArrayList<PermissionManager.Criterion>(1);
            criteria.add((alreadyChosenEntities, entity) -> {
                if (entity instanceof ContentEntityObject) {
                    ContentEntityObject ceo = (ContentEntityObject)entity;
                    long ceoId = ((ContentEntityObject)ceo.getLatestVersion()).getId();
                    for (Object alreadyChosenEntity : alreadyChosenEntities) {
                        ContentEntityObject ceo2 = (ContentEntityObject)alreadyChosenEntity;
                        long ceo2Id = ((ContentEntityObject)ceo2.getLatestVersion()).getId();
                        if (ceoId != ceo2Id) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            });
            ConfluenceUser user = this.userAccessor.getUserByName(this.username);
            this.recentlyUpdatedContent = this.getPermittedEntitiesOf(this.contentEntityManager.getRecentlyModifiedEntitiesForUser(user), 20, criteria);
        }
        return this.recentlyUpdatedContent;
    }

    public List getAuthoredSpaces() {
        return this.getPermittedEntitiesOf(this.spaceManager.getAuthoredSpacesByUser(FindUserHelper.getUserByUsername(this.username)));
    }

    @Override
    public boolean isEmailVisible() {
        return this.isMyProfile() || super.isEmailVisible();
    }

    public String renderEmail(String email) {
        return GeneralUtil.maskEmail(email, this.getGlobalSettings());
    }

    public List getFavouriteSpaces() {
        if (this.favouriteSpaces == null) {
            this.favouriteSpaces = AuthenticatedUserThreadLocal.get() == null ? Collections.EMPTY_LIST : this.getPermittedEntitiesOf(this.labelManager.getFavouriteSpaces(this.getAuthenticatedUser().getName()));
            Collections.sort(this.favouriteSpaces, new SpaceComparator());
        }
        return this.favouriteSpaces;
    }

    @Override
    public boolean isEditMode() {
        return false;
    }

    @Override
    protected List<String> getPermissionTypes() {
        List<String> permissionTypes = super.getPermissionTypes();
        if (this.shouldCheckBrowseUsersPermission(this.getAuthenticatedUser())) {
            this.addPermissionTypeTo("VIEWUSERPROFILES", permissionTypes);
        }
        return permissionTypes;
    }

    private boolean shouldCheckBrowseUsersPermission(ConfluenceUser user) {
        return user == null || !this.confluenceAccessManager.getUserAccessStatus(user).hasLicensedAccess();
    }

    @Override
    public String getEmail() {
        return super.getEmail() == null ? null : GeneralUtil.maskEmail(super.getEmail().toString(), this.getGlobalSettings());
    }
}

