/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.crowd;

import com.atlassian.confluence.user.DisabledUserManager;
import com.atlassian.confluence.user.UserManagementOperationFailedException;
import com.atlassian.confluence.user.crowd.CrowdUserConversionHelper;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.user.impl.EntityValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CrowdDisabledUserManager
implements DisabledUserManager {
    private static final Logger log = LoggerFactory.getLogger(CrowdDisabledUserManager.class);
    private final CrowdService crowdService;

    public CrowdDisabledUserManager(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Override
    public boolean isDisabled(User user) {
        return user != null && !user.isActive();
    }

    @Override
    public boolean isDisabled(com.atlassian.user.User user) {
        User crowdUser = new CrowdUserConversionHelper(this.crowdService).toCrowdUser(user);
        return this.isDisabled(crowdUser);
    }

    @Override
    public boolean isDisabled(String username) {
        if (username == null) {
            return false;
        }
        User user = this.crowdService.getUser(username);
        if (user == null) {
            return true;
        }
        return this.isDisabled(user);
    }

    @Override
    public void disableUser(User user) throws EntityValidationException, UserManagementOperationFailedException {
        if (!user.isActive()) {
            return;
        }
        UserTemplate crowdUser = new UserTemplate(user);
        crowdUser.setActive(false);
        try {
            this.crowdService.updateUser((User)crowdUser);
        }
        catch (InvalidUserException | UserNotFoundException e) {
            throw new EntityValidationException(e);
        }
        catch (OperationNotPermittedException | OperationFailedException e) {
            throw new UserManagementOperationFailedException(e);
        }
    }

    @Override
    public void disableEnableUserLocally(User user, boolean doEnable) throws EntityValidationException, UserManagementOperationFailedException {
        if (user == null || doEnable == user.isActive()) {
            return;
        }
        try {
            this.crowdService.setUserStatusLocally(user.getName(), doEnable);
        }
        catch (DirectoryNotFoundException | InvalidUserException e) {
            throw new EntityValidationException(e);
        }
        catch (OperationNotPermittedException | OperationFailedException e) {
            throw new UserManagementOperationFailedException(e);
        }
    }

    @Override
    public void enableUser(User user) throws EntityValidationException, UserManagementOperationFailedException {
        if (user.isActive()) {
            return;
        }
        UserTemplate crowdUser = new UserTemplate(user);
        crowdUser.setActive(true);
        try {
            this.crowdService.updateUser((User)crowdUser);
        }
        catch (InvalidUserException | UserNotFoundException e) {
            throw new EntityValidationException(e);
        }
        catch (OperationNotPermittedException | OperationFailedException e) {
            throw new UserManagementOperationFailedException(e);
        }
    }
}

