/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.listeners;

import com.atlassian.confluence.event.events.security.LogoutEvent;
import com.atlassian.confluence.setup.SetupContext;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.events.SessionDestroyedEvent;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.security.Principal;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSessionExpiryListener
implements HttpSessionListener {
    public static final Logger log = LoggerFactory.getLogger(UserSessionExpiryListener.class);
    private final Supplier<EventPublisher> eventPublisher;

    public UserSessionExpiryListener() {
        this(MemoizingComponentReference.containerComponent("eventPublisher"));
    }

    @VisibleForTesting
    UserSessionExpiryListener(Supplier<EventPublisher> eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        try {
            Principal user = (Principal)event.getSession().getAttribute("seraph_defaultauthenticator_user");
            String username = user != null ? user.getName() : null;
            this.getEventPublisher().publish((Object)SessionDestroyedEvent.builder().sessionId(event.getSession().getId()).userName(username).build());
            if (username != null) {
                this.getEventPublisher().publish((Object)new LogoutEvent(this, username, event.getSession().getId()));
            }
        }
        catch (IllegalStateException e) {
            log.error("Application server does not give us access to expired sessions. Listeners that depend on receiving LogoutEvent will not be reliable.  This web server is probably unsupported.", (Throwable)e);
        }
    }

    private EventPublisher getEventPublisher() {
        if (ContainerManager.isContainerSetup()) {
            return this.eventPublisher.get();
        }
        return (EventPublisher)SetupContext.get().getBean("setupEventPublisher", EventPublisher.class);
    }
}

