/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.persistence.dao;

import com.atlassian.seraph.service.rememberme.RememberMeToken;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Proxy;

@Entity
@Table(name="remembermetoken", indexes={@Index(name="rmt_username_idx", columnList="username")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Proxy(lazy=false)
public class ConfluenceRememberMeToken
implements RememberMeToken {
    @Id
    @GeneratedValue(generator="resettable-hilo-v5")
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    @Column(name="id", updatable=false)
    private Long id;
    @Column(name="username", nullable=false)
    private String username;
    @Column(name="token", nullable=false)
    private String token;
    @Column(name="created", nullable=false)
    private long createdTime;

    public ConfluenceRememberMeToken() {
    }

    public ConfluenceRememberMeToken(RememberMeToken token) {
        this.username = token.getUserName();
        this.token = token.getRandomString();
        this.id = token.getId();
        this.createdTime = token.getCreatedTime();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public Long getId() {
        return this.id;
    }

    public String getRandomString() {
        return this.token;
    }

    public String getUserName() {
        return this.username;
    }
}

