/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.persistence.dao.hibernate;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.persistence.dao.ConfluenceUserDao;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.seraph.auth.AuthenticationContext;
import com.atlassian.seraph.auth.AuthenticationContextImpl;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.dao.support.DataAccessUtils;

@ParametersAreNonnullByDefault
public class HibernateConfluenceUserDao
implements ConfluenceUserDao {
    private static final AuthenticationContext authenticationContext = new AuthenticationContextImpl();
    private final SessionFactory sessionFactory;

    public HibernateConfluenceUserDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void create(ConfluenceUser user) {
        this.sessionFactory.getCurrentSession().save((Object)user);
    }

    @Override
    public void update(ConfluenceUser user) {
        this.sessionFactory.getCurrentSession().update((Object)user);
    }

    @Override
    public @Nullable ConfluenceUser findByKey(@Nullable UserKey key) {
        if (key == null) {
            return null;
        }
        return (ConfluenceUser)this.sessionFactory.getCurrentSession().get(ConfluenceUserImpl.class, (Serializable)key);
    }

    @Override
    public @Nullable ConfluenceUser findByUsername(@Nullable String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return null;
        }
        Session session = this.sessionFactory.getCurrentSession();
        Principal authenticatedUser = authenticationContext.getUser();
        if (authenticatedUser instanceof ConfluenceUser && username.equals(authenticatedUser.getName()) && session.contains((Object)authenticatedUser)) {
            return (ConfluenceUser)((Object)authenticatedUser);
        }
        Query queryObject = session.createNamedQuery("confluence.confluenceuser_findByLowerUserName", ConfluenceUser.class);
        queryObject.setParameter("lowerUsername", (Object)IdentifierUtils.toLowerCase((String)username));
        ConfluenceUser user = (ConfluenceUser)queryObject.uniqueResult();
        if (user != null) {
            Hibernate.initialize((Object)user);
        }
        return user;
    }

    @Override
    public @NonNull Set<ConfluenceUser> getAll() {
        return this.findAll().collect(Collectors.toUnmodifiableSet());
    }

    private Stream<ConfluenceUserImpl> findAll() {
        return this.sessionFactory.getCurrentSession().createQuery("from ConfluenceUserImpl", ConfluenceUserImpl.class).stream();
    }

    @Override
    public Map<String, UserKey> findUserKeysByLowerNames(Iterable<String> names) {
        return this.findConfluenceUsersByLowerNames(names).stream().collect(Collectors.toMap(ConfluenceUser::getLowerName, ConfluenceUser::getKey));
    }

    @Override
    public List<ConfluenceUser> findConfluenceUsersByLowerNames(Iterable<String> lowerNames) {
        if (!lowerNames.iterator().hasNext()) {
            return Collections.emptyList();
        }
        Collection params = StreamSupport.stream(lowerNames.spliterator(), false).collect(Collectors.toList());
        List users = this.sessionFactory.getCurrentSession().createNamedQuery("confluence.confluenceuser_findByLowerNames", ConfluenceUserImpl.class).setParameterList("lowerNames", params).list();
        return users.stream().map(user -> user).collect(Collectors.toList());
    }

    @Override
    public List<UserKey> getAllUserKeys() {
        return this.findAll().map(ConfluenceUserImpl::getKey).collect(Collectors.toList());
    }

    @Override
    public Map<UserKey, String> findLowerNamesByKeys(Iterable<UserKey> keys) {
        Collection params = StreamSupport.stream(keys.spliterator(), false).collect(Collectors.toList());
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.confluenceuser_findLowerNamesByKeys", ConfluenceUserImpl.class).setParameterList("userKeys", params).stream().collect(Collectors.toMap(ConfluenceUserImpl::getKey, ConfluenceUserImpl::getLowerName));
    }

    private Optional<ConfluenceUser> getUnsyncedUser(UserKey key) {
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.confluenceuser_getUnsyncedUser", ConfluenceUser.class).setParameter("userKey", (Object)key).uniqueResultOptional();
    }

    private Optional<ConfluenceUser> getDeletedUser(UserKey key) {
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.confluenceuser_getDeletedUser", ConfluenceUser.class).setParameter("userKey", (Object)key).setCacheable(true).uniqueResultOptional();
    }

    @Override
    public boolean isDeletedUser(ConfluenceUser user) {
        return this.getDeletedUser(user.getKey()).isPresent();
    }

    @Override
    public boolean isUnsyncedUser(ConfluenceUser user) {
        return this.getUnsyncedUser(user.getKey()).isPresent();
    }

    @Override
    public List<ConfluenceUser> searchUnsyncedUsers(String searchParam) {
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.confluenceuser_searchUnsyncedUsers", ConfluenceUser.class).setParameter("lowerUsername", (Object)"%".concat(GeneralUtil.specialToLowerCase(searchParam).concat("%"))).list();
    }

    @Override
    public int countUnsyncedUsers() {
        return DataAccessUtils.intResult((Collection)this.sessionFactory.getCurrentSession().getNamedQuery("confluence.confluenceuser_countUnsyncedUsers").list());
    }

    @Override
    public Map<UserKey, Optional<ConfluenceUser>> findByKeys(Set<UserKey> userkeys) {
        if (userkeys.isEmpty()) {
            return Collections.emptyMap();
        }
        Stream users = this.sessionFactory.getCurrentSession().createNamedQuery("confluence.confluenceuser_bulkFindByUserKeys", ConfluenceUser.class).setParameter("userKeys", userkeys).stream();
        Map<UserKey, Optional<ConfluenceUser>> usersByKey = users.collect(Collectors.toMap(ConfluenceUser::getKey, Optional::of));
        userkeys.forEach(userKey -> usersByKey.putIfAbsent((UserKey)userKey, Optional.empty()));
        return usersByKey;
    }

    @Override
    public void remove(ConfluenceUser user) {
        this.sessionFactory.getCurrentSession().delete((Object)user);
    }

    @Override
    public @NonNull ConfluenceUser rename(String oldUsername, String newUsername, boolean overrideExisting) {
        ConfluenceUser user = Objects.requireNonNull(this.findByUsername(oldUsername));
        return this.doRename(user, newUsername, overrideExisting);
    }

    @Override
    public @NonNull ConfluenceUser rename(ConfluenceUser userToRename, String newUsername, boolean overrideExisting) {
        @NonNull ConfluenceUser user = Objects.requireNonNull(this.findByKey(userToRename.getKey()));
        return this.doRename(user, newUsername, overrideExisting);
    }

    private ConfluenceUser doRename(ConfluenceUser userToRename, String newUsername, boolean overrideExisting) {
        ConfluenceUserImpl user = (ConfluenceUserImpl)userToRename;
        String oldUsername = user.getName();
        user.setName(newUsername);
        if (!IdentifierUtils.equalsInLowerCase((String)oldUsername, (String)newUsername)) {
            this.updateLowerName(user, newUsername, overrideExisting);
        }
        this.sessionFactory.getCurrentSession().update((Object)user);
        this.sessionFactory.getCurrentSession().flush();
        return user;
    }

    @Override
    public void deactivateUser(String username) {
        ConfluenceUserImpl user = (ConfluenceUserImpl)this.findByUsername(username);
        if (user == null) {
            return;
        }
        user.setLowerName(null);
        this.sessionFactory.getCurrentSession().update((Object)user);
        this.sessionFactory.getCurrentSession().flush();
    }

    private void updateLowerName(ConfluenceUserImpl user, String newUsername, boolean overrideExisting) {
        if (overrideExisting) {
            this.deactivateUser(newUsername);
            user.setLowerName(IdentifierUtils.toLowerCase((String)newUsername));
        } else {
            user.setLowerName(null);
        }
    }
}

