/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.user.rememberme;

import com.atlassian.confluence.user.persistence.dao.ConfluenceRememberMeToken;
import com.atlassian.confluence.user.rememberme.ConfluenceRememberMeTokenDao;
import com.atlassian.seraph.service.rememberme.RememberMeToken;
import com.atlassian.seraph.spi.rememberme.RememberMeConfiguration;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;

public class DefaultConfluenceRememberMeTokenDao
implements ConfluenceRememberMeTokenDao {
    private final SessionFactory sessionFactory;
    private final RememberMeConfiguration rememberMeConfiguration;

    public DefaultConfluenceRememberMeTokenDao(SessionFactory sessionFactory, RememberMeConfiguration rememberMeConfiguration) {
        this.sessionFactory = sessionFactory;
        this.rememberMeConfiguration = rememberMeConfiguration;
    }

    @Override
    public RememberMeToken findById(Long tokenId) {
        return tokenId == null ? null : (RememberMeToken)this.sessionFactory.getCurrentSession().get(ConfluenceRememberMeToken.class, (Serializable)tokenId);
    }

    @Override
    public List<RememberMeToken> findForUserName(String username) {
        if (username == null) {
            return Collections.emptyList();
        }
        return this.sessionFactory.getCurrentSession().createQuery("from ConfluenceRememberMeToken where username = :username", RememberMeToken.class).setParameter("username", (Object)username).list();
    }

    @Override
    public void remove(Long tokenId) {
        if (tokenId != null) {
            this.delete("from ConfluenceRememberMeToken where id = :tokenId", query -> query.setParameter("tokenId", (Object)tokenId));
        }
    }

    @Override
    public void removeAll() {
        this.delete("from ConfluenceRememberMeToken", quqey -> {});
    }

    @Override
    public void removeAllForUser(String username) {
        if (username != null) {
            this.delete("from ConfluenceRememberMeToken where username = :username", query -> query.setParameter("username", (Object)username));
        }
    }

    @Override
    public RememberMeToken save(RememberMeToken token) {
        if (token == null) {
            return null;
        }
        ConfluenceRememberMeToken confluenceRememberMeToken = new ConfluenceRememberMeToken(token);
        this.sessionFactory.getCurrentSession().save((Object)confluenceRememberMeToken);
        return confluenceRememberMeToken;
    }

    @Override
    public void removeExpiredTokens() {
        this.delete("from ConfluenceRememberMeToken where created < :expiredCutoff", query -> query.setParameter("expiredCutoff", (Object)(System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(this.rememberMeConfiguration.getCookieMaxAgeInSeconds()))));
    }

    private void delete(String hql, Consumer<Query<?>> parameterSetter) {
        Session session = this.sessionFactory.getCurrentSession();
        Query query = session.createQuery(hql, ConfluenceRememberMeToken.class);
        parameterSetter.accept(query);
        query.list().forEach(arg_0 -> ((Session)session).delete(arg_0));
    }
}

