/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.setup.SetupContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBootstrapHotSwappingFilter
extends HttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBootstrapHotSwappingFilter.class);
    private final AtomicReference<Filter> filterTarget = new AtomicReference<SwapOnBootstrapFilter>(new SwapOnBootstrapFilter());

    public abstract Filter getSwapTarget() throws ServletException;

    public final void doFilter(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.filterTarget.get().doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse, filterChain);
    }

    private class SwapOnBootstrapFilter
    extends HttpFilter {
        private SwapOnBootstrapFilter() {
        }

        public void doFilter(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            if (SetupContext.isAvailable()) {
                filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                return;
            }
            try {
                AbstractBootstrapHotSwappingFilter.this.filterTarget.compareAndSet((Filter)this, AbstractBootstrapHotSwappingFilter.this.getSwapTarget());
                AbstractBootstrapHotSwappingFilter.this.doFilter(servletRequest, servletResponse, filterChain);
            }
            catch (ServletException | RuntimeException e) {
                LOG.debug("Could not get swap target filter", e);
                LOG.error("Could not get swap target filter", (Object)e.getMessage());
                filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            }
        }
    }
}

