/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.CharMatcher;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ClusterHeaderFilter
extends HttpFilter {
    private static final Logger log = LoggerFactory.getLogger(ClusterHeaderFilter.class);
    private final Supplier<ClusterManager> clusterManagerRef = MemoizingComponentReference.containerComponent("clusterManager");
    private final AtomicReference<String> lastNodeNameThatWeWarnedAbout = new AtomicReference();

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Maybe<ClusterNodeInformation> nodeRef = this.getClusterNode();
        if (nodeRef.isDefined()) {
            ClusterNodeInformation clusterNode = (ClusterNodeInformation)nodeRef.get();
            response.setHeader("X-Confluence-Cluster-Node", clusterNode.getAnonymizedNodeIdentifier());
            Optional nodeNameRef = clusterNode.humanReadableNodeName();
            if (nodeNameRef.isPresent()) {
                String nodeName = (String)nodeNameRef.get();
                if (CharMatcher.ascii().matchesAllOf((CharSequence)nodeName)) {
                    response.setHeader("X-Confluence-Cluster-Node-Name", nodeName);
                } else if (this.shouldWarnAboutNonAsciiName(nodeName)) {
                    log.warn("Cannot set non-ASCII cluster node name [{}] as HTTP response header", (Object)nodeName);
                }
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean shouldWarnAboutNonAsciiName(String nodeName) {
        return !nodeName.equals(this.lastNodeNameThatWeWarnedAbout.getAndSet(nodeName));
    }

    private Maybe<ClusterNodeInformation> getClusterNode() {
        if (!ContainerManager.isContainerSetup()) {
            return Option.none();
        }
        return Option.option((Object)this.clusterManagerRef.get().getThisNodeInformation());
    }
}

