/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.util.http.Rfc6265CookieProcessor;
import org.apache.tomcat.util.http.SameSiteCookies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtil {
    private static final Logger log = LoggerFactory.getLogger(CookieUtil.class);
    private static final String DEFAULT_SAME_SITE = "Lax";
    public static final CookieUtil INSTANCE = new CookieUtil();

    private CookieUtil() {
    }

    public static String getSameSiteAttributeFromTomcatContext(HttpServletRequest request) {
        try {
            Field applicationContextField = request.getServletContext().getClass().getDeclaredField("context");
            applicationContextField.setAccessible(true);
            Object applicationContext = applicationContextField.get(request.getServletContext());
            if (applicationContext instanceof ApplicationContext) {
                SameSiteCookies sameSiteCookiesEnum;
                Field standardContextField = applicationContext.getClass().getDeclaredField("context");
                standardContextField.setAccessible(true);
                Object standardContext = standardContextField.get(applicationContext);
                if (standardContext instanceof StandardContext && (sameSiteCookiesEnum = ((Rfc6265CookieProcessor)((StandardContext)standardContext).getCookieProcessor()).getSameSiteCookies()) != null && sameSiteCookiesEnum != SameSiteCookies.UNSET) {
                    return sameSiteCookiesEnum.getValue();
                }
            }
        }
        catch (Exception e) {
            log.info("Error retrieving SameSite attribute from Tomcat context: {}", (Object)e.getMessage());
        }
        return DEFAULT_SAME_SITE;
    }
}

