/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.platform.security.PathTraversalChecker;
import com.google.common.base.CharMatcher;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public final class FilesystemUtils {
    private static final Set<Character> ILLEGAL_WINDOWS_FILE_NAMING_CHARS = Set.of(Character.valueOf('?'), Character.valueOf('\"'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('*'), Character.valueOf('|'), Character.valueOf(':'), Character.valueOf('\\'));
    private static final Set<Character> ILLEGAL_UNIX_FILE_NAMING_CHARS = Set.of(Character.valueOf('/'), Character.valueOf('%'));
    private static final Set<Character> NOT_RECOMMENDED_NAMING_CHARS = Set.of(Character.valueOf('+'), Character.valueOf('&'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('`'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('('), Character.valueOf(')'));
    private static final Set<String> ILLEGAL_WINDOWS_FILE_NAMES = Set.of("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9");
    private static final Set<String> ILLEGAL_UNIX_FILE_NAMES = Set.of("");

    public static boolean isSafeTitleForFilesystem(String title) {
        if (StringUtils.isEmpty((CharSequence)title)) {
            return false;
        }
        if (title.length() >= 150) {
            return false;
        }
        if (title.endsWith(" ") || title.endsWith(".")) {
            return false;
        }
        if (!CharMatcher.ascii().matchesAllOf((CharSequence)title)) {
            return false;
        }
        for (int i = 0; i < title.length(); ++i) {
            char c = title.charAt(i);
            if (c < ' ') {
                return false;
            }
            if (ILLEGAL_WINDOWS_FILE_NAMING_CHARS.contains(Character.valueOf(c))) {
                return false;
            }
            if (ILLEGAL_UNIX_FILE_NAMING_CHARS.contains(Character.valueOf(c))) {
                return false;
            }
            if (!NOT_RECOMMENDED_NAMING_CHARS.contains(Character.valueOf(c))) continue;
            return false;
        }
        if (ILLEGAL_WINDOWS_FILE_NAMES.contains(title.toUpperCase())) {
            return false;
        }
        return !ILLEGAL_UNIX_FILE_NAMES.contains(title);
    }

    public static boolean containsEncodedPathTraversal(String str, Charset charset) {
        return PathTraversalChecker.containsPathTraversal((String)FilesystemUtils.loopedResoluteUrlDecode(str, charset));
    }

    @Deprecated
    public static boolean containsEncodedPathTraversal(String str) {
        return FilesystemUtils.containsEncodedPathTraversal(str, GeneralUtil.getDefaultCharset());
    }

    private static String loopedResoluteUrlDecode(String str, Charset charset) {
        String prev;
        String original = str;
        int i = 0;
        do {
            prev = str;
            try {
                str = URLDecoder.decode(prev, charset);
            }
            catch (IllegalArgumentException e) {
                str = HtmlUtil.resoluteUrlDecode(prev, charset);
            }
            if (i++ < 100) continue;
            throw new IllegalArgumentException("Unable to decode string " + original + " after 100 iterations");
        } while (!str.equals(prev));
        return str;
    }

    public static boolean isSafePath(String path) {
        if (Path.of(path, new String[0]).isAbsolute()) {
            return false;
        }
        Path validatePath = Path.of("root", path);
        if (validatePath.normalize() != validatePath) {
            return false;
        }
        return !PathTraversalChecker.containsPathTraversal((String)path);
    }

    public static boolean isSafePath(Path path) {
        if (path.isAbsolute()) {
            return false;
        }
        return FilesystemUtils.isSafePath(path.toString());
    }

    public static String getFileChecksum(String path) {
        try {
            return new DigestUtils("SHA-256").digestAsHex(new File(path));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error while calculating checksum for file at path " + path, e);
        }
    }
}

