/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.util;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.internal.persistence.SalRetryConnectionCallback;
import com.atlassian.confluence.internal.persistence.TransactionRetryInterceptorConfig;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AddressablePage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Contained;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.util.BooleanFuse;
import com.atlassian.confluence.util.VelocityUtil;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.web.UrlBuilder;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.dc.filestore.impl.filesystem.FilesystemFileStore;
import com.atlassian.renderer.util.UrlUtil;
import com.atlassian.sal.api.rdbms.ConnectionCallback;
import com.atlassian.sal.api.rdbms.TransactionalExecutor;
import com.atlassian.spring.container.ContainerManager;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneralUtil
extends VelocityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralUtil.class);
    public static final GeneralUtil INSTANCE = new GeneralUtil();
    private static Long systemStartupTime;
    private static final String[] JAVASCRIPT_ESCAPE_FIND;
    private static final String[] JAVASCRIPT_ESCAPE_REPLACE;
    private static final Supplier<Boolean> isReadyFuse;

    public static void setSystemStartupTime(Long systemStartupTime) {
        GeneralUtil.systemStartupTime = systemStartupTime;
    }

    public static Long getSystemStartupTime() {
        return systemStartupTime;
    }

    public static File createTempDirectoryInConfluenceTemp(String prefix) {
        Date date = new Date();
        String pattern = "_{0,date,MMddyyyy}_{1,time,HHmmss}";
        String uniqueRandomFileName = MessageFormat.format(pattern, date, date);
        Path basePath = Path.of(BootstrapUtils.getBootstrapManager().getFilePathProperty("struts.multipart.saveDir"), new String[0]);
        FilesystemPath fileBasePath = FilesystemFileStore.forPath((Path)basePath);
        FilesystemPath canonicalFilePath = fileBasePath.path(new String[]{prefix + uniqueRandomFileName});
        return canonicalFilePath.asJavaFile();
    }

    private static String appendQueryParams(String path, HttpServletRequest request) {
        return path + (String)(request.getQueryString() == null ? "" : "?" + request.getQueryString());
    }

    public static String getRequestPath(HttpServletRequest request) {
        return request.getServletPath() + (request.getPathInfo() == null ? "" : request.getPathInfo());
    }

    public static String getRequestUrl(HttpServletRequest request) {
        return GeneralUtil.appendQueryParams(GeneralUtil.getRequestPath(request), request);
    }

    public static String getOriginalPath(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    public static String getOriginalUrl(HttpServletRequest request) {
        return GeneralUtil.appendQueryParams(GeneralUtil.getOriginalPath(request), request);
    }

    public static String getIdBasedPageUrl(AbstractPage page) {
        if (page == null) {
            return "";
        }
        return AddressablePage.of(page).getIdBasedPageUrl();
    }

    public static String getEditPageUrl(AbstractPage page) {
        Objects.requireNonNull(page);
        UrlBuilder url = new UrlBuilder("/pages/resumedraft.action").add("draftId", page.getId());
        String pageShareId = page.getShareId();
        if (pageShareId != null) {
            url.add("draftShareId", pageShareId);
        }
        return url.toUrl();
    }

    public static String getAttachmentUrl(Attachment attachment) {
        ContentEntityObject container = Objects.requireNonNull(attachment.getContainer());
        String previewParamValue = "/" + container.getId() + "/" + ((Attachment)attachment.getLatestVersion()).getId() + "/" + attachment.getFileName();
        return new UrlBuilder(Objects.requireNonNull(GeneralUtil.getParentPageOrBlog(attachment)).getUrlPath()).add("preview", previewParamValue).toUrl();
    }

    public static String getCommentUrl(Attachment attachment, Comment comment) {
        ContentEntityObject container = Objects.requireNonNull(attachment.getContainer());
        String previewParamValue = comment.getParent() == null ? "/" + container.getId() + "/" + ((Attachment)attachment.getLatestVersion()).getId() + "/" + attachment.getVersion() + "/" + comment.getId() + "/" + attachment.getFileName() : "/" + container.getId() + "/" + ((Attachment)attachment.getLatestVersion()).getId() + "/" + attachment.getVersion() + "/" + GeneralUtil.getParentComment(comment).getId() + "/" + comment.getId() + "/" + attachment.getFileName();
        return new UrlBuilder(Objects.requireNonNull(GeneralUtil.getParentPageOrBlog(attachment)).getUrlPath()).add("preview", previewParamValue).toUrl();
    }

    public static @Nullable AbstractPage getParentPageOrBlog(Contained content) {
        Object container = content.getContainer();
        if (container instanceof AbstractPage) {
            return (AbstractPage)container;
        }
        if (container instanceof Contained) {
            return GeneralUtil.getParentPageOrBlog((Contained)container);
        }
        return null;
    }

    public static Comment getParentComment(Comment comment) {
        if (comment == null) {
            return null;
        }
        if (comment.getParent() == null) {
            return comment;
        }
        return GeneralUtil.getParentComment(comment.getParent());
    }

    public static String displayShortUrl(String url) {
        return GeneralUtil.displayShortUrl(url, 32);
    }

    public static String displayShortUrl(String url, int length) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        if (UrlUtil.startsWithUrl((String)url)) {
            if (url.startsWith("http://")) {
                url = url.substring(7);
            }
            boolean containsGoogle = url.contains(".google.");
            int indexOfQuery = url.indexOf("q=");
            if (containsGoogle && indexOfQuery >= 0) {
                url = GeneralUtil.extractGoogleUrl(url, indexOfQuery);
            }
        }
        if (url.length() < length) {
            return url;
        }
        return url.substring(0, length - 1) + "\u2026";
    }

    private static String extractGoogleUrl(String url, int indexOfQuery) {
        try {
            int indexOfAmpersand = ((String)url).indexOf("&", indexOfQuery);
            String googleQueryPhrase = indexOfAmpersand > -1 ? ((String)url).substring(indexOfQuery + 2, indexOfAmpersand) : ((String)url).substring(indexOfQuery + 2);
            url = "Google: " + URLDecoder.decode(googleQueryPhrase, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    @Deprecated(forRemoval=true)
    public static Date toEndOfMonth(Calendar postDate, boolean isSqlServer) {
        Instant instant = postDate.getTime().toInstant().atZone(postDate.getTimeZone().toZoneId()).truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1).plusMonths(1L).toInstant().minusMillis(isSqlServer ? 3L : 1L);
        return Date.from(instant);
    }

    public static void copyDate(Calendar original, Calendar copy) {
        int[] calendarPeriods;
        for (int p : calendarPeriods = new int[]{1, 2, 5, 11, 12, 13, 14}) {
            copy.set(p, original.get(p));
        }
    }

    public static Charset getDefaultCharset() {
        try {
            return Charset.forName(GeneralUtil.getCharacterEncoding());
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            LOG.warn("Will use OS default charset {}, Could not Charset for encoding {} with error : {}", new Object[]{Charset.defaultCharset(), GeneralUtil.getCharacterEncoding(), unsupportedCharsetException.getMessage()});
            return Charset.defaultCharset();
        }
    }

    public static String escapeForJavascript(String s) {
        return StringUtils.replaceEach((String)s, (String[])JAVASCRIPT_ESCAPE_FIND, (String[])JAVASCRIPT_ESCAPE_REPLACE);
    }

    public static boolean isSetupComplete() {
        return BootstrapUtils.getBootstrapContext() != null && BootstrapUtils.getBootstrapManager() != null && BootstrapUtils.getBootstrapManager().isSetupComplete();
    }

    public static boolean isReadyToServe() {
        return isReadyFuse.get();
    }

    public static String alwaysMaskEmail(String emailAddress) {
        StringBuilder buf = new StringBuilder(emailAddress.length() + 20);
        for (int i = 0; i < emailAddress.length(); ++i) {
            char c = emailAddress.charAt(i);
            if (c == '.') {
                buf.append(" dot ");
                continue;
            }
            if (c == '@') {
                buf.append(" at ");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String escapeCDATA(String s) {
        if (!s.contains("]]")) {
            return s;
        }
        return s.replaceAll("]]", "]] ");
    }

    public static String unescapeCDATA(String s) {
        if (!s.contains("]] ")) {
            return s;
        }
        return s.replaceAll("]] ", "]]");
    }

    public static I18NBean getI18n() {
        return (I18NBean)ContainerManager.getComponent((String)"i18NBean");
    }

    public static String replaceInvalidXmlCharacters(String text) {
        if (text == null) {
            return null;
        }
        char[] chars = text.toCharArray();
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            int ch = text.charAt(i);
            if (ch >= 55296 && ch <= 56319) {
                if (++i < len) {
                    char low = text.charAt(i);
                    if (low < '\udc00' || low > '\udfff') {
                        chars[i - 1] = 65533;
                        chars[i] = 65533;
                        continue;
                    }
                    ch = 65536 + (ch - 55296) * 1024 + (low - 56320);
                } else {
                    chars[i - 1] = 65533;
                    continue;
                }
            }
            if (GeneralUtil.isXMLCharacter(ch)) continue;
            chars[i] = 65533;
        }
        return String.valueOf(chars);
    }

    private static boolean isXMLCharacter(int c) {
        if (c == 10 || c == 13 || c == 9) {
            return true;
        }
        if (c < 32) {
            return false;
        }
        if (c <= 55295) {
            return true;
        }
        if (c < 57344) {
            return false;
        }
        if (c <= 65533) {
            return true;
        }
        if (c < 65536) {
            return false;
        }
        return c <= 0x10FFFF;
    }

    public static String specialToLowerCase(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        try {
            AtlassianBootstrapManager bootstrapManager = BootstrapUtils.getBootstrapManager();
            if (bootstrapManager == null || bootstrapManager.getApplicationConfig() == null) {
                return str.toLowerCase();
            }
            return GeneralUtil.specialToLowerCase(str, bootstrapManager.getApplicationConfig());
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to perform specialLowerCase, failing back to regular lower case", (Throwable)e);
            return str.toLowerCase();
        }
    }

    public static String specialToLowerCase(String str, ApplicationConfiguration appConfig) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        boolean propertyIsNotSet = appConfig.getProperty((Object)"hibernate.database.lower_non_ascii_supported") == null;
        boolean lowerSupported = appConfig.getBooleanProperty((Object)"hibernate.database.lower_non_ascii_supported");
        if (propertyIsNotSet || lowerSupported) {
            return str.toLowerCase();
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!GeneralUtil.isAscii(chars[i])) continue;
            chars[i] = Character.toLowerCase(chars[i]);
        }
        return new String(chars);
    }

    public static Settings getGlobalSettings() {
        if (!ContainerManager.isContainerSetup()) {
            return null;
        }
        return ((GlobalSettingsManager)ContainerManager.getComponent((String)"globalSettingsManager", GlobalSettingsManager.class)).getGlobalSettings();
    }

    public static String[] splitCommaDelimitedString(String escapedNames) {
        if (StringUtils.isEmpty((CharSequence)escapedNames)) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentName = new StringBuilder();
        int i = 0;
        while (i < escapedNames.length()) {
            char c;
            if ((c = escapedNames.charAt(i++)) == '\\') {
                currentName.append(escapedNames.charAt(i++));
                continue;
            }
            if (c != ',') {
                currentName.append(c);
                continue;
            }
            result.add(currentName.toString().trim());
            currentName = new StringBuilder();
        }
        if (StringUtils.isNotEmpty((CharSequence)currentName.toString())) {
            result.add(currentName.toString().trim());
        }
        return result.toArray(new String[0]);
    }

    @Deprecated(forRemoval=true)
    public static Map<String, String> convertBeanToMap(Object bean) {
        Map beanMap;
        if (bean == null) {
            return Collections.emptyMap();
        }
        try {
            beanMap = BeanUtils.describe((Object)bean);
            beanMap.remove("class");
        }
        catch (ReflectiveOperationException ex) {
            LOG.warn("Exception while converting an information bean to a Map.", (Throwable)ex);
            return Collections.emptyMap();
        }
        return beanMap;
    }

    public static <T, S> S applyIfNonNull(T delegate, Function<T, S> wrapper) {
        return delegate != null ? (S)wrapper.apply(delegate) : null;
    }

    public static String unescapeEntities(String str) {
        Pattern hexEntityPattern = Pattern.compile("&([a-fA-F0-9]+);");
        Pattern decimalEntityPattern = Pattern.compile("&#([0-9]+);");
        str = GeneralUtil.replaceNumericEntities(str, hexEntityPattern, 16);
        return GeneralUtil.replaceNumericEntities(str, decimalEntityPattern, 10);
    }

    private static String replaceNumericEntities(String str, Pattern pattern, int base) {
        Matcher matcher = pattern.matcher(str);
        StringBuilder buf = new StringBuilder(str.length());
        while (matcher.find()) {
            matcher.appendReplacement(buf, Character.toString((char)Integer.parseInt(matcher.group(1), base)));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    @Deprecated(forRemoval=true)
    public static <T> T executeRetryableTransaction(TransactionalExecutor executor, ConnectionCallback<T> callback) {
        return SalRetryConnectionCallback.execute(TransactionRetryInterceptorConfig.transactionRetryTemplate(), executor, callback);
    }

    static {
        JAVASCRIPT_ESCAPE_FIND = new String[]{"\\", "'", "\""};
        JAVASCRIPT_ESCAPE_REPLACE = new String[]{"\\\\", "\\'", "\\\""};
        isReadyFuse = new BooleanFuse(false, () -> ContainerManager.isContainerSetup() && GeneralUtil.isSetupComplete());
    }
}

